/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine;

import edu.uic.cs.nlp.chiqat.plugin.base.BasePluginInstance;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.EngineExecutor;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.ActionDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeDefinition;
import edu.uic.cs.nlp.chiqat.plugin.woeplugin.engine.definition.WoeStepDefinition;
import java.util.List;

public class WoeEngine {
    protected WoeDefinition m_Definition = null;
    protected static WoeEngine s_Singleton = null;
    protected EngineExecutor m_Execution = null;
    protected BasePluginInstance m_PluginInstance = null;
    protected String m_PlaybackPluginId = "";
    protected String m_PlaybackControllerId = "";

    public WoeEngine(String playbackPluginId, String playbackControllerId, BasePluginInstance inst) {
        this.m_PlaybackPluginId = playbackPluginId;
        this.m_PlaybackControllerId = playbackControllerId;
        this.m_PluginInstance = inst;
    }

    public boolean CreateNewWoe() {
        this.m_Definition = new WoeDefinition();
        this.AddStep();
        return true;
    }

    public boolean LoadWoe(String path) {
        this.m_Definition = new WoeDefinition();
        if (!this.m_Definition.Load(path)) {
            this.m_Definition = null;
        }
        return this.m_Definition != null;
    }

    public boolean SaveWoe(String path) {
        if (this.m_Definition != null) {
            return this.m_Definition.Save(path);
        }
        return false;
    }

    public boolean SaveWoe() {
        if (this.m_Definition != null) {
            return this.m_Definition.Save();
        }
        return false;
    }

    public boolean Play() {
        boolean bSuccess = false;
        if (this.m_Definition != null) {
            if (this.m_Execution != null) {
                this.m_Execution.Shutdown(false);
            }
            this.m_Execution = new EngineExecutor(this.m_Definition, this.m_PluginInstance, this.m_PlaybackPluginId, this.m_PlaybackControllerId);
            this.m_Execution.Start();
            bSuccess = true;
        }
        return bSuccess;
    }

    public boolean Stop() {
        boolean bSuccess = false;
        if (this.m_Definition != null && this.m_Execution != null) {
            this.m_Execution.Shutdown(false);
            this.m_Execution = null;
            this.m_Definition = null;
            bSuccess = true;
        }
        return bSuccess;
    }

    public List<ActionDefinition> GetCurrentActions() {
        if (this.m_Definition != null && this.m_Execution != null) {
            return this.GetCurrentStep().CFG_Actions;
        }
        return null;
    }

    protected WoeStepDefinition GetCurrentStep() {
        return this.m_Execution != null ? this.m_Execution.GetCurrentStep() : null;
    }

    public WoeStepDefinition GetStep(int iId) {
        for (WoeStepDefinition wsd : this.m_Definition.CFG_Steps) {
            if (wsd.CFG_Id != iId) continue;
            return wsd;
        }
        return null;
    }

    public WoeStepDefinition AddStep() {
        return this.m_Definition.AddStep();
    }

    public WoeDefinition GetDefinition() {
        return this.m_Definition;
    }

    public boolean RemoveStep(int iId) {
        int i = 0;
        while (i < this.m_Definition.CFG_Steps.size()) {
            if (this.m_Definition.CFG_Steps.get((int)i).CFG_Id == iId) {
                this.m_Definition.CFG_Steps.remove(iId);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void OnStudentResponse(int iResponse) {
        if (this.m_Execution != null) {
            this.m_Execution.SetStimulus(iResponse);
        }
    }

    public String GetPlaybackPluginId() {
        return this.m_PlaybackPluginId;
    }

    public String GetPlaybackControllerId() {
        return this.m_PlaybackControllerId;
    }
}

