/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.chiqat.server.api;

import edu.uic.cs.nlp.chiqat.server.api.ILogCommitListener;
import edu.uic.cs.nlp.chiqat.server.api.structs.AddLogEntriesRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.AddLogEntriesResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.CreateUserRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.CreateUserResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetUserControlInfoRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetUserControlInfoResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetUserRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetUserResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetVersionInfoRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.GetVersionInfoResponse;
import edu.uic.cs.nlp.chiqat.server.api.structs.SetUserControlInfoRequest;
import edu.uic.cs.nlp.chiqat.server.api.structs.SetUserControlInfoResponse;
import edu.uic.cs.nlp.toolbox.MiscFuncs;
import edu.uic.cs.nlp.toolbox.WebMiscFuncs;

public class ChiQatServerCom {
    public static final String ClientVersionStr = "0.1.2";
    public static final int ClientVersionNum = MiscFuncs.StringVersionToInt("0.1.2");
    public String m_MinServerVersion = "0.0.1";
    public String Url_CreateUser = "http://www.digitaltutor.net/chiqat/server/signup.php";
    public String Url_GetVersionInfo = "http://www.digitaltutor.net/chiqat/server/version.php";
    public String Url_GetUser = "http://www.digitaltutor.net/chiqat/server/user.php";
    public String Url_AddLogEntries = "http://www.digitaltutor.net/chiqat/server/log.php";
    public String Url_GetUserControlInfo = "http://www.digitaltutor.net/chiqat/server/getcontrolinfo.php";
    public String Url_SetUserControlInfo = "http://www.digitaltutor.net/chiqat/server/setcontrolinfo.php";

    public InitResult Init() {
        InitResult res = InitResult.S_OK;
        GetVersionInfoResponse response = this.GetServerVersion();
        res = response != null ? (MiscFuncs.StringVersionToInt(response.minimum_client_version) > ClientVersionNum ? InitResult.E_NewVersionRequired : (ClientVersionNum < MiscFuncs.StringVersionToInt(response.latest_client_version) ? InitResult.S_NewVersionAvailable : (MiscFuncs.StringVersionToInt(this.m_MinServerVersion) > MiscFuncs.StringVersionToInt(response.server_version) ? InitResult.E_IncompatibleWithServer : InitResult.S_OK))) : InitResult.S_ServerNotAvailable;
        return res;
    }

    public GetVersionInfoResponse GetServerVersion() {
        GetVersionInfoRequest req = new GetVersionInfoRequest();
        GetVersionInfoResponse response = WebMiscFuncs.PostToServer(this.Url_GetVersionInfo, req, GetVersionInfoResponse.class);
        return response;
    }

    public CreateUserResponse CreateUser(CreateUserRequest req) {
        CreateUserResponse response = WebMiscFuncs.PostToServer(this.Url_CreateUser, req, CreateUserResponse.class);
        return response;
    }

    public GetUserResponse GetUser(String emailAddr, String password) {
        GetUserRequest req = new GetUserRequest();
        req.email_addr = emailAddr;
        req.password = password;
        return this.GetUser(req);
    }

    public GetUserResponse GetUser(GetUserRequest req) {
        GetUserResponse response = WebMiscFuncs.PostToServer(this.Url_GetUser, req, GetUserResponse.class);
        return response;
    }

    public boolean AddLogEntries(AddLogEntriesRequest req, ILogCommitListener logCommitListener, boolean bArchiveLog, String fileName) {
        if (req.entries.size() > 0) {
            try {
                class AsyncTask
                implements Runnable {
                    AddLogEntriesRequest req = null;
                    ILogCommitListener logCommitListener = null;
                    boolean bArchiveLog = false;
                    String fileName = "";

                    AsyncTask(AddLogEntriesRequest req, ILogCommitListener logCommitListener, boolean bArchiveLog, String fileName) {
                        this.req = req;
                        this.logCommitListener = logCommitListener;
                        this.bArchiveLog = bArchiveLog;
                        this.fileName = fileName;
                    }

                    @Override
                    public void run() {
                        boolean bSuccess;
                        int iRetry = 10;
                        while (iRetry-- > 0) {
                            AddLogEntriesResponse response = WebMiscFuncs.PostToServer(ChiQatServerCom.this.Url_AddLogEntries, this.req, AddLogEntriesResponse.class);
                            if (response != null && response.result.compareToIgnoreCase("S_OK") == 0) break;
                            try {
                                Thread.sleep((11 - iRetry) * 100);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        boolean bl = bSuccess = iRetry > 0;
                        if (this.logCommitListener != null) {
                            this.logCommitListener.OnLogCommitResult(this.req, bSuccess, this.bArchiveLog, this.fileName);
                        }
                    }
                }
                new Thread(new AsyncTask(req, logCommitListener, bArchiveLog, fileName)).start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public GetUserControlInfoResponse GetUserControlInfo(GetUserControlInfoRequest req) {
        return WebMiscFuncs.PostToServer(this.Url_GetUserControlInfo, req, GetUserControlInfoResponse.class);
    }

    public GetUserControlInfoResponse GetUserControlInfo(int iUserId) {
        return this.GetUserControlInfo(new GetUserControlInfoRequest(iUserId));
    }

    public SetUserControlInfoResponse SetUserControlInfo(SetUserControlInfoRequest req) {
        return WebMiscFuncs.PostToServer(this.Url_SetUserControlInfo, req, SetUserControlInfoResponse.class);
    }

    public static enum InitResult {
        S_OK,
        S_NewVersionAvailable,
        S_ServerNotAvailable,
        E_NewVersionRequired,
        E_IncompatibleWithServer;

    }
}

