/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.toolbox;

import edu.uic.cs.nlp.toolbox.MiscFuncs;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class CsvParser {
    protected String[] m_HeaderMap = null;
    protected List<String[]> m_Entries = new ArrayList<String[]>();
    protected char m_Seperator = (char)44;

    public static CsvParser FromFile(String path) {
        CsvParser parser = new CsvParser();
        if (parser.Load(path)) {
            return parser;
        }
        return null;
    }

    public void SetSeperator(char c) {
        this.m_Seperator = c;
    }

    public void SetHeaderMap(String[] headers) {
        this.m_HeaderMap = headers;
    }

    public boolean Load(String path) {
        boolean bSuccess = false;
        this.m_Entries = new ArrayList<String[]>();
        String fileStr = MiscFuncs.LoadFileAsString(path);
        Vector<String> lines = MiscFuncs.ParseString(fileStr, '\n', true);
        if (lines.size() > 0) {
            Vector<String> lineParts = MiscFuncs.ParseString((String)lines.get(0), this.m_Seperator, true);
            this.m_HeaderMap = new String[lineParts.size()];
            int i = 0;
            while (i < lineParts.size()) {
                this.m_HeaderMap[i] = (String)lineParts.get(i);
                ++i;
            }
            i = 1;
            while (i < lines.size()) {
                lineParts = MiscFuncs.ParseString((String)lines.get(i), this.m_Seperator, true);
                String[] entryLine = new String[lineParts.size()];
                int j = 0;
                while (j < lineParts.size()) {
                    entryLine[j] = (String)lineParts.get(j);
                    ++j;
                }
                this.m_Entries.add(entryLine);
                ++i;
            }
            bSuccess = true;
        }
        return bSuccess;
    }

    public String Get(int iEntryNum, String header) {
        String[] s;
        String ret = null;
        int iCol = this.GetColIndexOfHeader(header);
        if (iCol != -1 && iEntryNum < this.m_Entries.size() && iCol < (s = this.m_Entries.get(iEntryNum)).length) {
            ret = s[iCol];
        }
        return ret;
    }

    public int GetColIndexOfHeader(String str) {
        int i = 0;
        while (i < this.m_HeaderMap.length) {
            if (this.m_HeaderMap[i].compareToIgnoreCase(str) == 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void AddEntry(String[] entry) {
        this.m_Entries.add(entry);
    }

    public int GetNumEntries() {
        return this.m_Entries.size();
    }

    public boolean Save(String destPath) {
        StringBuilder str = new StringBuilder();
        int i = 0;
        while (i < this.m_HeaderMap.length) {
            if (i < this.m_HeaderMap.length - 1) {
                str.append(String.valueOf(this.m_HeaderMap[i]) + this.m_Seperator);
            } else {
                str.append(this.m_HeaderMap[i]);
            }
            ++i;
        }
        str.append("\n");
        i = 0;
        while (i < this.m_Entries.size()) {
            String[] entry = this.m_Entries.get(i);
            int j = 0;
            while (j < entry.length) {
                if (j < entry.length - 1) {
                    str.append(String.valueOf(entry[j]) + this.m_Seperator);
                } else {
                    str.append(entry[j]);
                }
                ++j;
            }
            str.append("\n");
            ++i;
        }
        return MiscFuncs.SaveFileAsString(str.toString(), destPath);
    }

    public void ClearEntries() {
        this.m_Entries.clear();
    }
}

