/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.toolbox;

import java.io.Serializable;

public class ExponentialSmoother
implements Serializable {
    private static final long serialVersionUID = 1L;
    private double alpha;
    private double y = 0.0;
    private double prev = 0.0;
    private int n = 0;

    public static void main(String[] args) {
        double x;
        ExponentialSmoother s = new ExponentialSmoother(0.5);
        int i = 1;
        while (i <= 10) {
            x = 100.0;
            s.addSample(x);
            System.out.println("i = " + i + ", x = " + x + ", y = " + s.getValue());
            ++i;
        }
        i = 11;
        while (i <= 20) {
            x = 0.0;
            s.addSample(x);
            System.out.println("i = " + i + ", x = " + x + ", y = " + s.getValue());
            ++i;
        }
    }

    public ExponentialSmoother(double alpha) {
        if (alpha < 0.0) {
            alpha = 0.0;
        } else if (alpha > 1.0) {
            alpha = 1.0;
        }
        this.alpha = alpha;
    }

    public void addSample(double x) {
        ++this.n;
        this.prev = this.y;
        this.y = this.alpha * x + (1.0 - this.alpha) * this.y;
    }

    public int numSamples() {
        return this.n;
    }

    public double getValue() {
        return this.y;
    }

    public double getPreviousValue() {
        return this.prev;
    }

    public void clear(double initValue) {
        this.prev = initValue;
        this.y = initValue;
        this.n = 0;
    }
}

