/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.toolbox;

import edu.uic.cs.nlp.toolbox.Rect;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MiscFuncs {
    protected static Pattern s_UnicodeOutliers = null;
    protected static Random s_GlobalRand = new Random(System.currentTimeMillis());
    protected static Lock s_RandLock = new ReentrantLock();
    protected static EntityReference[] EntityRefs = new EntityReference[]{new EntityReference('&', "amp", 38), new EntityReference('\"', "quot", 34), new EntityReference('\'', "apos", 39), new EntityReference('<', "lt", 60), new EntityReference('>', "gt", 62), new EntityReference('\u00a0', "nbsp", 160), new EntityReference('\u00a1', "iexcl", 161), new EntityReference('\u00a2', "cent", 162), new EntityReference('\u00a3', "pound", 163), new EntityReference('\u00a4', "curren", 164), new EntityReference('\u00a5', "yen", 165), new EntityReference('\u00a6', "brvbar", 166), new EntityReference('\u00a7', "sect", 167), new EntityReference('\u00a8', "uml", 168), new EntityReference('\u00a9', "copy", 169), new EntityReference('\u00aa', "ordf", 170), new EntityReference('\u00ab', "laquo", 171), new EntityReference('\u00ac', "not", 172), new EntityReference('\u00ad', "shy", 173), new EntityReference('\u00ae', "reg", 174), new EntityReference('\u00af', "macr", 175), new EntityReference('\u00b0', "deg", 176), new EntityReference('\u00b1', "plusmn", 177), new EntityReference('\u00b2', "sup2", 178), new EntityReference('\u00b3', "sup3", 179), new EntityReference('\u00b4', "acute", 180), new EntityReference('\u00b5', "micro", 181), new EntityReference('\u00b6', "para", 182), new EntityReference('\u00b7', "middot", 183), new EntityReference('\u00b8', "cedil", 184), new EntityReference('\u00b9', "sup1", 185), new EntityReference('\u00ba', "ordm", 186), new EntityReference('\u00bb', "raquo", 187), new EntityReference('\u00bc', "frac14", 188), new EntityReference('\u00bd', "frac12", 189), new EntityReference('\u00be', "frac34", 190), new EntityReference('\u00bf', "iquest", 191), new EntityReference('\u00d7', "times", 215), new EntityReference('\u00f7', "divide", 247), new EntityReference('\u00c0', "Agrave", 192), new EntityReference('\u00c1', "Aacute", 193), new EntityReference('\u00c2', "Acirc", 194), new EntityReference('\u00c3', "Atilde", 195), new EntityReference('\u00c4', "Auml", 196), new EntityReference('\u00c5', "Aring", 197), new EntityReference('\u00c6', "AElig", 198), new EntityReference('\u00c7', "Ccedil", 199), new EntityReference('\u00c8', "Egrave", 200), new EntityReference('\u00c9', "Eacute", 201), new EntityReference('\u00ca', "Ecirc", 202), new EntityReference('\u00cb', "Euml", 203), new EntityReference('\u00cc', "Igrave", 204), new EntityReference('\u00cd', "Iacute", 205), new EntityReference('\u00ce', "Icirc", 206), new EntityReference('\u00cf', "Iuml", 207), new EntityReference('\u00d0', "ETH", 208), new EntityReference('\u00d1', "Ntilde", 209), new EntityReference('\u00d2', "Ograve", 210), new EntityReference('\u00d3', "Oacute", 211), new EntityReference('\u00d4', "Ocirc", 212), new EntityReference('\u00d5', "Otilde", 213), new EntityReference('\u00d6', "Ouml", 214), new EntityReference('\u00d8', "Oslash", 216), new EntityReference('\u00d9', "Ugrave", 217), new EntityReference('\u00da', "Uacute", 218), new EntityReference('\u00db', "Ucirc", 219), new EntityReference('\u00dc', "Uuml", 220), new EntityReference('\u00dd', "Yacute", 221), new EntityReference('\u00de', "THORN", 222), new EntityReference('\u00df', "szlig", 223), new EntityReference('\u00e0', "agrave", 224), new EntityReference('\u00e1', "aacute", 225), new EntityReference('\u00e2', "acirc", 226), new EntityReference('\u00e3', "atilde", 227), new EntityReference('\u00e4', "auml", 228), new EntityReference('\u00e5', "aring", 229), new EntityReference('\u00e6', "aelig", 230), new EntityReference('\u00e7', "ccedil", 231), new EntityReference('\u00e8', "egrave", 232), new EntityReference('\u00e9', "eacute", 233), new EntityReference('\u00ea', "ecirc", 234), new EntityReference('\u00eb', "euml", 235), new EntityReference('\u00ec', "igrave", 236), new EntityReference('\u00ed', "iacute", 237), new EntityReference('\u00ee', "icirc", 238), new EntityReference('\u00ef', "iuml", 239), new EntityReference('\u00f0', "eth", 240), new EntityReference('\u00f1', "ntilde", 241), new EntityReference('\u00f2', "ograve", 242), new EntityReference('\u00f3', "oacute", 243), new EntityReference('\u00f4', "ocirc", 244), new EntityReference('\u00f5', "otilde", 245), new EntityReference('\u00f6', "ouml", 246), new EntityReference('\u00f8', "oslash", 248), new EntityReference('\u00f9', "ugrave", 249), new EntityReference('\u00fa', "uacute", 250), new EntityReference('\u00fb', "ucirc", 251), new EntityReference('\u00fc', "uuml", 252), new EntityReference('\u00fd', "yacute", 253), new EntityReference('\u00fe', "thorn", 254), new EntityReference('\u00ff', "yuml", 255)};

    public static String ResolveXmlEntities(String text) {
        String retText = "";
        int iStartBlock = 0;
        int iIndex = 0;
        while (iIndex != -1 && iIndex < text.length()) {
            if ((iIndex = text.indexOf(38, iIndex)) == -1) {
                retText = String.valueOf(retText) + text.substring(iStartBlock, text.length());
                break;
            }
            int iEnd = text.indexOf(59, iIndex);
            if (iEnd != -1 && iEnd - iIndex < 7) {
                String ref = text.substring(iIndex, iEnd + 1);
                int i = 0;
                while (i < EntityRefs.length) {
                    if (ref.equalsIgnoreCase("&" + MiscFuncs.EntityRefs[i].m_Ref + ";")) {
                        if (iStartBlock < iIndex - 1) {
                            retText = String.valueOf(retText) + text.substring(iStartBlock, iIndex);
                        }
                        retText = String.valueOf(retText) + MiscFuncs.EntityRefs[i].m_Char;
                        iStartBlock = iIndex + MiscFuncs.EntityRefs[i].m_Ref.length() + 2;
                        break;
                    }
                    ++i;
                }
            }
            ++iIndex;
        }
        return retText;
    }

    public static String EncodeEntityString(String str) {
        EntityReference[] entityReferenceArray = EntityRefs;
        int n = EntityRefs.length;
        int n2 = 0;
        while (n2 < n) {
            EntityReference er = entityReferenceArray[n2];
            str = str.replace("" + er.m_Char, "&" + er.m_Ref + ";");
            ++n2;
        }
        return str;
    }

    public static String BlockStripper(String text, String[][] tagPairs) {
        return MiscFuncs.BlockStripper(text, tagPairs, true);
    }

    public static String BlockStripper(String text, String[][] tagPairs, boolean bRecursive) {
        return MiscFuncs.BlockStripper(text, tagPairs, bRecursive, null);
    }

    public static String BlockStripper(String text, String[][] tagPairs, boolean bRecursive, Vector<String> extracts) {
        String retStr = "";
        int iStartBlock = 0;
        int iIndex = 0;
        while (iIndex != -1 && iIndex < text.length()) {
            int iNextIndex = -1;
            int iPairIndex = -1;
            int i = 0;
            while (i < tagPairs.length) {
                int j = text.indexOf(tagPairs[i][0], iIndex);
                if (iNextIndex == -1 || j != -1 && j < iNextIndex) {
                    iNextIndex = j;
                    iPairIndex = i;
                }
                ++i;
            }
            iIndex = iNextIndex;
            if (iIndex == -1) {
                retStr = String.valueOf(retStr) + text.substring(iStartBlock, text.length());
                break;
            }
            int iMarkupEndIndex = -1;
            if (!bRecursive) {
                iMarkupEndIndex = text.indexOf(tagPairs[iPairIndex][1], iIndex);
                if (iMarkupEndIndex != -1) {
                    iMarkupEndIndex += tagPairs[iPairIndex][1].length();
                }
            } else {
                int iDepth = 1;
                iMarkupEndIndex = iIndex + tagPairs[iPairIndex][0].length();
                while (iDepth > 0 && iMarkupEndIndex != -1) {
                    int iNextClose;
                    int iNextOpen = text.indexOf(tagPairs[iPairIndex][0], iMarkupEndIndex);
                    if (iNextOpen != -1) {
                        iNextOpen += tagPairs[iPairIndex][0].length();
                    }
                    if ((iNextClose = text.indexOf(tagPairs[iPairIndex][1], iMarkupEndIndex)) != -1) {
                        iNextClose += tagPairs[iPairIndex][1].length();
                    }
                    if (iNextClose == -1) {
                        iMarkupEndIndex = -1;
                        continue;
                    }
                    if (iNextOpen == -1 || iNextClose < iNextOpen) {
                        --iDepth;
                        iMarkupEndIndex = iNextClose;
                        continue;
                    }
                    ++iDepth;
                    iMarkupEndIndex = iNextOpen;
                }
                if (iDepth > 0) {
                    iMarkupEndIndex = -1;
                }
            }
            if (iMarkupEndIndex != -1) {
                if (iIndex > iStartBlock) {
                    retStr = String.valueOf(retStr) + text.substring(iStartBlock, iIndex);
                }
                if (extracts != null && iMarkupEndIndex - tagPairs[iPairIndex][1].length() > iIndex + tagPairs[iPairIndex][0].length()) {
                    String block = text.substring(iIndex + tagPairs[iPairIndex][0].length(), iMarkupEndIndex - tagPairs[iPairIndex][1].length());
                    extracts.add(block);
                }
                iIndex = iStartBlock = iMarkupEndIndex;
                continue;
            }
            ++iIndex;
        }
        return retStr;
    }

    public static int FindCharacterRun(String str, char c, int iLen) {
        return MiscFuncs.FindCharacterRun(str, c, iLen, 0);
    }

    public static int FindCharacterRun(String str, char c, int iLen, int iStartIndex) {
        int iIndex = iStartIndex;
        while (iIndex != -1) {
            if ((iIndex = str.indexOf(c, iIndex)) == -1) continue;
            boolean bPrevDiff = iIndex == 0 || str.charAt(iIndex - 1) != c;
            int iCount = 1;
            while (iIndex + iCount < str.length() && str.charAt(iIndex + iCount) == c) {
                ++iCount;
            }
            if (bPrevDiff && iCount == iLen) {
                return iIndex;
            }
            iIndex += iCount;
        }
        return -1;
    }

    public static String TruncateString(String str, int iLength) {
        if (iLength < str.length()) {
            return str.substring(0, iLength);
        }
        return str;
    }

    public static int CountRepeatChar(String str, char c, int iStart) {
        int iCount = 0;
        while (iStart + iCount < str.length() && str.charAt(iStart + iCount) == c) {
            ++iCount;
        }
        return iCount;
    }

    public static Vector<String> BlockExtractor(String text, String[][] tagPairs) {
        return MiscFuncs.BlockExtractor(text, tagPairs, true);
    }

    public static Vector<String> BlockExtractor(String text, String[][] tagPairs, boolean bRecursive) {
        Vector<String> retStrs = new Vector<String>();
        int iStartBlock = 0;
        int iIndex = 0;
        while (iIndex != -1 && iIndex < text.length()) {
            int iNextIndex = -1;
            int iPairIndex = -1;
            int i = 0;
            while (i < tagPairs.length) {
                int j = text.indexOf(tagPairs[i][0], iIndex);
                if (iNextIndex == -1 || j != -1 && j < iNextIndex) {
                    iNextIndex = j;
                    iPairIndex = i;
                }
                ++i;
            }
            iIndex = iNextIndex;
            if (iIndex == -1) break;
            int iMarkupEndIndex = -1;
            if (!bRecursive) {
                iMarkupEndIndex = text.indexOf(tagPairs[iPairIndex][1], iIndex);
                if (iMarkupEndIndex != -1) {
                    iMarkupEndIndex += tagPairs[iPairIndex][1].length();
                }
            } else {
                int iDepth = 1;
                iMarkupEndIndex = iIndex + tagPairs[iPairIndex][0].length();
                while (iDepth > 0 && iMarkupEndIndex != -1) {
                    int iNextClose;
                    int iNextOpen = text.indexOf(tagPairs[iPairIndex][0], iMarkupEndIndex);
                    if (iNextOpen != -1) {
                        iNextOpen += tagPairs[iPairIndex][0].length();
                    }
                    if ((iNextClose = text.indexOf(tagPairs[iPairIndex][1], iMarkupEndIndex)) != -1) {
                        iNextClose += tagPairs[iPairIndex][1].length();
                    }
                    if (iNextClose == -1) {
                        iMarkupEndIndex = -1;
                        continue;
                    }
                    if (iNextOpen == -1 || iNextClose < iNextOpen) {
                        --iDepth;
                        iMarkupEndIndex = iNextClose;
                        continue;
                    }
                    ++iDepth;
                    iMarkupEndIndex = iNextOpen;
                }
                if (iDepth > 0) {
                    iMarkupEndIndex = -1;
                }
            }
            if (iMarkupEndIndex != -1) {
                if (iMarkupEndIndex - tagPairs[iPairIndex][1].length() > iIndex + tagPairs[iPairIndex][0].length()) {
                    String block = text.substring(iIndex + tagPairs[iPairIndex][0].length(), iMarkupEndIndex - tagPairs[iPairIndex][1].length());
                    retStrs.add(block);
                }
                iIndex = iStartBlock = iMarkupEndIndex;
                continue;
            }
            ++iIndex;
        }
        return retStrs;
    }

    public static String RemoveDuplicates(String text, String[] tokens) {
        String retStr = "";
        int iStartBlock = 0;
        int iIndex = 0;
        while (iIndex != -1 && iIndex < text.length()) {
            int iNextIndex = -1;
            int iTokenIndex = -1;
            int i = 0;
            while (i < tokens.length) {
                int j = text.indexOf(tokens[i], iIndex);
                if (iNextIndex == -1 || j != -1 && j < iNextIndex) {
                    iNextIndex = j;
                    iTokenIndex = i;
                }
                ++i;
            }
            iIndex = iNextIndex;
            if (iIndex == -1) {
                retStr = String.valueOf(retStr) + text.substring(iStartBlock, text.length());
                break;
            }
            String token = tokens[iTokenIndex];
            int iDuplicateEndIndex = iIndex + token.length();
            boolean bEnd = false;
            while (!bEnd && iDuplicateEndIndex + token.length() < text.length()) {
                int i2 = 0;
                while (i2 < token.length() && !bEnd) {
                    if (token.charAt(i2) != text.charAt(iDuplicateEndIndex + i2)) {
                        bEnd = true;
                    }
                    ++i2;
                }
                if (bEnd) continue;
                iDuplicateEndIndex += token.length();
            }
            if (iDuplicateEndIndex > iIndex + token.length()) {
                if (iIndex > iStartBlock) {
                    retStr = String.valueOf(retStr) + text.substring(iStartBlock, iIndex + token.length());
                }
                iIndex = iStartBlock = iDuplicateEndIndex;
                continue;
            }
            ++iIndex;
        }
        return retStr;
    }

    public static int IndexOfAny(String str, String[] tokens, int iStart) {
        int iIndex = -1;
        int i = 0;
        while (i < tokens.length) {
            int j = str.indexOf(tokens[i], iStart);
            if (iIndex == -1 || j != -1 && j < iIndex) {
                iIndex = j;
            }
            ++i;
        }
        return iIndex;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] ParseCliString(String str) {
        elements = new Vector<String>();
        iStartIndex = 0;
        ** GOTO lbl32
        {
            ++iStartIndex;
            do {
                if (iStartIndex < str.length() && str.charAt(iStartIndex) == ' ') continue block0;
                if (iStartIndex >= str.length()) break block0;
                iEndIndex = -1;
                if (str.charAt(iStartIndex) == '\"') {
                    iEndIndex = iStartIndex;
                    while ((iEndIndex = str.indexOf(34, iEndIndex + 1)) > 0 && str.charAt(iEndIndex - 1) == '\\') {
                    }
                    if (iEndIndex == -1) {
                        iEndIndex = str.length();
                    }
                } else {
                    iWhiteSpace = str.indexOf(32, iStartIndex + 1);
                    iQuote = str.indexOf(34, iStartIndex + 1);
                    if (iWhiteSpace == -1) {
                        iWhiteSpace = str.length();
                    }
                    if (iQuote == -1) {
                        iQuote = str.length();
                    }
                    iEndIndex = iWhiteSpace < iQuote ? iWhiteSpace : iQuote;
                }
                e = str.substring(iStartIndex, iEndIndex);
                if ((e = e.trim()).length() > 0 && e.charAt(0) == '\"') {
                    v0 = e = e.length() == 1 ? "" : e.substring(1, e.length());
                }
                if (e.length() > 0 && e.charAt(e.length() - 1) == '\"') {
                    e = e.length() == 1 ? "" : e.substring(1, e.length());
                }
                iStartIndex = iEndIndex + 1;
                if (e.length() <= 0) continue;
                elements.add(e);
lbl32:
                // 3 sources

            } while (iStartIndex != -1 && iStartIndex < str.length());
        }
        out = new String[elements.size()];
        i = 0;
        while (i < elements.size()) {
            out[i] = (String)elements.get(i);
            ++i;
        }
        return out;
    }

    public static Vector<String> ParseString(String str, char separater, boolean bTrim) {
        Vector<String> v = new Vector<String>();
        int iStartIndex = 0;
        while (iStartIndex != -1 && iStartIndex < str.length()) {
            int iEndIndex = -1;
            if (iEndIndex + 1 < str.length()) {
                iEndIndex = str.indexOf(separater, iStartIndex);
            }
            if (iEndIndex == -1) {
                iEndIndex = str.length();
            }
            String s = "";
            if (iStartIndex != iEndIndex) {
                s = str.substring(iStartIndex, iEndIndex);
                v.add(bTrim ? s.trim() : s);
            }
            iStartIndex = iEndIndex + 1;
        }
        return v;
    }

    public static Vector<String> ParseString(String str, String separater, boolean bTrim) {
        Vector<String> v = new Vector<String>();
        int iStartIndex = 0;
        while (iStartIndex != -1 && iStartIndex < str.length()) {
            int iEndIndex = -1;
            if (iEndIndex + 1 < str.length()) {
                iEndIndex = str.indexOf(separater, iStartIndex);
            }
            if (iEndIndex == -1) {
                iEndIndex = str.length();
            }
            String s = "";
            if (iStartIndex != iEndIndex) {
                s = str.substring(iStartIndex, iEndIndex);
                v.add(bTrim ? s.trim() : s);
            }
            iStartIndex = iEndIndex + separater.length();
        }
        return v;
    }

    public static Vector<String> ParseString(String str, char separater) {
        return MiscFuncs.ParseString(str, separater, false);
    }

    public static String ArrayToString(String[] array) {
        String out = "";
        int j = 0;
        while (j < array.length) {
            out = String.valueOf(out) + array[j] + (j < array.length - 1 ? " " : "");
            ++j;
        }
        return out;
    }

    public static void CreateDirectory(String dir) {
        File f = new File(dir);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    public static String AddEscapeToQuotes(String str) {
        str = str.replace("\\", "\\\\");
        str = str.replace("'", "\\'");
        str = str.replace("\"", "\\\"");
        return str;
    }

    public static String TrimString(String str) {
        return str.replaceAll("^[\\s,\\|]*|[\\s,\\|]*$", "");
    }

    public static String RemoveNonUtf8Chars(String str) {
        if (s_UnicodeOutliers == null) {
            s_UnicodeOutliers = Pattern.compile("[^\\x00-\\x7F]", 194);
        }
        Matcher unicodeOutlierMatcher = s_UnicodeOutliers.matcher(str);
        return unicodeOutlierMatcher.replaceAll(" ");
    }

    public static String LoadFileAsString(String path) {
        FileInputStream inputStream = null;
        InputStreamReader streamReader = null;
        BufferedReader bufferedReader = null;
        StringBuilder fileText = new StringBuilder();
        try {
            inputStream = new FileInputStream(path);
            streamReader = new InputStreamReader((InputStream)inputStream, "UTF8");
            bufferedReader = new BufferedReader(streamReader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (fileText.length() > 0) {
                    fileText.append("\n" + line);
                    continue;
                }
                fileText.append(line);
            }
        }
        catch (Exception e) {
            fileText = null;
        }
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return fileText == null ? "" : fileText.toString();
    }

    public static boolean SaveFileAsString(String text, String path) {
        boolean bSuccess = false;
        PrintWriter out = null;
        try {
            out = new PrintWriter(path);
            out.println(text);
            bSuccess = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (out != null) {
            out.close();
        }
        return bSuccess;
    }

    public static String[] ToStringArray(Vector<String> vec) {
        String[] a = new String[vec.size()];
        int i = 0;
        while (i < vec.size()) {
            a[i] = vec.get(i);
            ++i;
        }
        return a;
    }

    public static void AddToVector(Vector<String> master, Vector<String> slave) {
        for (String s : slave) {
            master.addElement(s);
        }
    }

    public static Vector<String> RemoveDuplicateStrings(Vector<String> strs) {
        Vector ret = (Vector)strs.clone();
        int i = 0;
        while (i < ret.size()) {
            int j = i + 1;
            while (j < ret.size()) {
                if (((String)ret.get(i)).compareToIgnoreCase((String)ret.get(j)) == 0) {
                    ret.remove(j);
                    continue;
                }
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static Integer IntTryParse(String str) {
        Integer i = 0;
        try {
            i = Integer.parseInt(str.trim());
        }
        catch (Exception e) {
            i = null;
        }
        return i;
    }

    public static Boolean BoolTryParse(String str) {
        Boolean b = false;
        try {
            b = Boolean.parseBoolean(str.trim());
        }
        catch (Exception e) {
            b = null;
        }
        return b;
    }

    public static Byte ByteTryParse(String str) {
        Byte b = 0;
        try {
            b = Byte.parseByte(str.trim());
        }
        catch (Exception e) {
            b = null;
        }
        return b;
    }

    public static Double DoubleTryParse(String str) {
        Double d = 0.0;
        try {
            d = Double.parseDouble(str.trim());
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static Long LongTryParse(String str) {
        Long d = 0L;
        try {
            d = Long.parseLong(str.trim());
        }
        catch (Exception e) {
            d = null;
        }
        return d;
    }

    public static Float FloatTryParse(String str) {
        Float f = Float.valueOf(0.0f);
        try {
            f = Float.valueOf(Float.parseFloat(str.trim()));
        }
        catch (Exception e) {
            f = null;
        }
        return f;
    }

    public static byte[] streamToByteArray(InputStream in) {
        byte[] b = null;
        try {
            byte[] c;
            int len = 4096;
            b = new byte[len];
            int off = 0;
            int nread = 0;
            while ((nread = in.read(b, off, len - off)) > 0) {
                if ((off += nread) != len) continue;
                c = new byte[len *= 2];
                System.arraycopy(b, 0, c, 0, off);
                b = c;
            }
            if (off < len) {
                c = new byte[off];
                System.arraycopy(b, 0, c, 0, off);
                b = c;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }

    public static String slurpFile(URL url) {
        String s = null;
        try {
            int c;
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder sb = new StringBuilder();
            while ((c = reader.read()) != -1) {
                sb.append((char)c);
            }
            s = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String slurpFile(String fileName) {
        File f = new File(fileName);
        return MiscFuncs.slurpFile(f);
    }

    public static String slurpFile(File f) {
        String s;
        try {
            int c;
            FileReader fr = new FileReader(f);
            StringBuilder sb = new StringBuilder();
            while ((c = fr.read()) != -1) {
                sb.append((char)c);
            }
            s = sb.toString();
        }
        catch (Exception e) {
            s = null;
            e.printStackTrace();
        }
        return s;
    }

    public static Vector<String> tokenize(String s) {
        Vector<String> v = new Vector<String>();
        Scanner scan = new Scanner(s);
        while (scan.hasNext()) {
            v.add(scan.next());
        }
        return v;
    }

    public static String englishList(List<String> list) {
        int n = list.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return list.get(0);
        }
        if (n == 2) {
            return String.valueOf(list.get(0)) + " and " + list.get(1);
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < n - 1) {
            s.append(list.get(i));
            s.append(", ");
            ++i;
        }
        s.append("and ");
        s.append(list.get(n - 1));
        return s.toString();
    }

    public static String capitalizeFirst(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 2) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0).toUpperCase()) + s.substring(1, len);
    }

    public static Vector<String> getSubBlocks(String text) {
        Vector<String> result = new Vector<String>();
        int braces = 0;
        int n = text.length();
        boolean output = false;
        StringBuilder block = new StringBuilder();
        int i = 0;
        while (i < n) {
            char c = text.charAt(i);
            if (output) {
                block.append(c);
            }
            if (c == '{') {
                if (++braces == 1) {
                    output = true;
                    block = new StringBuilder();
                }
            } else if (c == '}' && --braces == 0) {
                output = false;
                block.deleteCharAt(block.length() - 1);
                result.add(block.toString());
            }
            ++i;
        }
        return result;
    }

    public static byte[] graphToPNG(String graphDOT) {
        byte[] img = null;
        try {
            Process dot = Runtime.getRuntime().exec("dot -Tpng");
            OutputStreamWriter pout = new OutputStreamWriter(dot.getOutputStream());
            InputStream pin = dot.getInputStream();
            pout.write(graphDOT);
            pout.close();
            img = MiscFuncs.streamToByteArray(pin);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return img;
    }

    public static String graphToPS(String graphDOT) {
        String ps = null;
        try {
            int c;
            Process dot = Runtime.getRuntime().exec("dot -Tps");
            OutputStreamWriter pout = new OutputStreamWriter(dot.getOutputStream());
            InputStream pin = dot.getInputStream();
            pout.write(graphDOT);
            pout.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(pin));
            StringBuilder sb = new StringBuilder();
            while ((c = reader.read()) != -1) {
                sb.append((char)c);
            }
            ps = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ps;
    }

    public static void saveString(String s, String fileName) {
        try {
            FileWriter out = new FileWriter(fileName);
            out.write(s);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String stripHTML(String htmlText) {
        String result = htmlText;
        result = result.replaceAll("\n", " ");
        result = result.replaceAll("<br>", "\n");
        result = result.replaceAll("</p>", "\n");
        result = result.replaceAll("<(.+)?>", "");
        result = result.trim();
        return result;
    }

    public static String renderNumberedList(List<String> items) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : items) {
            sb.append(String.valueOf(++i) + ") " + s + "\n");
        }
        return sb.toString();
    }

    public static Map<String, String> ParseQueryString(String str) {
        HashMap<String, String> ret = new HashMap<String, String>();
        Vector<String> parts = MiscFuncs.ParseString(str, '&');
        for (String part : parts) {
            int iSepIndex = part.indexOf(61);
            if (iSepIndex <= 0) continue;
            String key = part.substring(0, iSepIndex);
            String val = "";
            if (iSepIndex < part.length()) {
                val = part.substring(iSepIndex + 1, part.length());
            }
            ret.put(key, val);
        }
        return ret;
    }

    public static boolean DoRectsIntersect(Rect rectA, Rect rectB) {
        return rectA.m_dLeft < rectB.m_dRight && rectA.m_dRight > rectB.m_dLeft && rectA.m_dTop < rectB.m_dBottom && rectA.m_dBottom > rectB.m_dTop;
    }

    public static boolean IsAbsolutePath(String path) {
        return path.contains("://") || path.contains(":\\") || path.startsWith("/");
    }

    public static boolean IsPathDirectory(String path) {
        File f = new File(path);
        return f.exists() && f.isDirectory();
    }

    public static boolean IsPathFile(String path) {
        File f = new File(path);
        return f.exists() && f.isFile();
    }

    public static boolean CreateFile(String path) {
        File f = new File(path);
        if (!f.exists()) {
            try {
                f.createNewFile();
                return true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean IsWindows() {
        return System.getProperty("os.name").compareToIgnoreCase("Windows") == 0;
    }

    public static boolean IsLinux() {
        return System.getProperty("os.name").compareToIgnoreCase("Linux") == 0;
    }

    public static boolean IsOsx() {
        return System.getProperty("os.name").compareToIgnoreCase("OSX") == 0;
    }

    public static boolean CopyFile(String src, String dest) {
        boolean bSuccess = false;
        try {
            Files.copy(new File(src).toPath(), new File(dest).toPath(), new CopyOption[0]);
            bSuccess = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bSuccess;
    }

    public static boolean ExecuteApplication(String cmd, String[] args, boolean bWaitForCompletion) {
        boolean bSuccess = false;
        String[] full = new String[args.length + 1];
        full[0] = cmd;
        int i = 0;
        while (i < args.length) {
            full[i + 1] = args[i];
            ++i;
        }
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(full);
            if (p != null) {
                bSuccess = true;
                if (bWaitForCompletion) {
                    p.waitFor();
                }
            }
        }
        catch (IOException | InterruptedException e) {
            bSuccess = false;
        }
        return bSuccess;
    }

    public static long GetLocalTimeMs() {
        return new Date().getTime();
    }

    public static int GetLocalTimeSec() {
        return (int)(new Date().getTime() / 1000L);
    }

    public static void CopyDirectoryContent(String srcDir, String destDir) {
        File[] files;
        File dir = new File(srcDir);
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            MiscFuncs.CopyFile(f.getPath(), String.valueOf(destDir) + "/" + f.getName());
            ++n2;
        }
    }

    public static void DeleteDirectory(String dirStr) {
        MiscFuncs.DeleteDirectory(new File(dirStr));
    }

    public static void DeleteDirectory(File folder) {
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    MiscFuncs.DeleteDirectory(f);
                } else {
                    f.delete();
                }
                ++n2;
            }
        }
        folder.delete();
    }

    public static boolean RenameFile(String srcPath, String tarPath) {
        boolean bSuccess = false;
        try {
            Path src = new File(srcPath).toPath();
            Path tar = new File(tarPath).toPath();
            Files.move(src, tar, StandardCopyOption.REPLACE_EXISTING);
            bSuccess = true;
        }
        catch (IOException e) {
            int i = 0;
            ++i;
        }
        return bSuccess;
    }

    public static String GetRandomString() {
        return MiscFuncs.GetRandomString(31);
    }

    public static String GetRandomString(int iLen) {
        s_RandLock.lock();
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < iLen) {
            char ch = (char)(s_GlobalRand.nextInt(42) + 48);
            if (ch >= ':' && ch <= '@') continue;
            builder.append(ch);
            ++i;
        }
        s_RandLock.unlock();
        return builder.toString();
    }

    public static int StringVersionToInt(String versionStr) {
        int iVersion = 0;
        Vector<String> parts = MiscFuncs.ParseString(versionStr, '.');
        int i = 0;
        while (i < parts.size() && i < 4) {
            try {
                int iPart = Integer.parseInt(parts.get(i));
                iVersion |= iPart << (3 - i) * 8;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i;
        }
        return iVersion;
    }

    public static String GetDifference(String before, String after) {
        int iStartDiff = 0;
        while (iStartDiff < before.length() && iStartDiff < after.length() && before.charAt(iStartDiff) == after.charAt(iStartDiff)) {
            ++iStartDiff;
        }
        int iEndDiff = 0;
        while (iEndDiff < before.length() && iEndDiff < after.length() && before.charAt(before.length() - iEndDiff - 1) == after.charAt(after.length() - iEndDiff - 1)) {
            ++iEndDiff;
        }
        String diffStr = "";
        iEndDiff = after.length() - iEndDiff;
        if (iEndDiff - iStartDiff > 0) {
            diffStr = after.substring(iStartDiff, iEndDiff);
        }
        return diffStr;
    }

    public static void OpenWebpage(URI uri) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(uri);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void OpenWebpage(String url) {
        try {
            MiscFuncs.OpenWebpage(new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static void OpenWebpage(URL url) {
        try {
            MiscFuncs.OpenWebpage(url.toURI());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String str1 = MiscFuncs.GetDifference("I'm a little chunky", "I'm very chunky");
        String str2 = MiscFuncs.GetDifference("I'm very chunky", "I'm very chunky");
        String str3 = MiscFuncs.GetDifference("mooing is very good", "");
        String str4 = MiscFuncs.GetDifference("mooing is very good", "hi there!");
        String str5 = MiscFuncs.GetDifference("mooing is very good", "-mooing is very good-");
        String str6 = MiscFuncs.GetDifference("abcdefg", "abc1234defg");
        String str7 = MiscFuncs.GetDifference("abc1234defg", "abcdefg");
        String str8 = MiscFuncs.GetDifference("", "");
    }

    static class EntityReference {
        public char m_Char = (char)32;
        public String m_Ref = "";
        public int m_iCode = 0;

        public EntityReference(char c, String r, int iCode) {
            this.m_Char = c;
            this.m_Ref = r;
            this.m_iCode = 0;
        }
    }

    public class FileFilter
    implements FilenameFilter {
        public String m_FileExtension = "sql";
        public boolean m_bStrict = false;

        @Override
        public boolean accept(File dir, String name) {
            int iLastIndex = name.lastIndexOf(46);
            if (iLastIndex == -1) {
                return false;
            }
            int iIndex = name.indexOf("." + this.m_FileExtension, iLastIndex);
            if (iIndex != iLastIndex) {
                return false;
            }
            return !this.m_bStrict || iIndex - name.length() == this.m_FileExtension.length();
        }
    }
}

