/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.toolbox;

import edu.uic.cs.nlp.toolbox.ManualResetEvent;

public abstract class ThreadObject
extends Thread {
    protected ManualResetEvent m_FinishedEvt = null;
    protected ManualResetEvent m_BeginShutdownEvt = null;
    protected ManualResetEvent m_ThreadCompleteEvt = null;
    protected int m_iStackSize = 0;
    protected boolean m_bRunning = false;
    protected boolean m_bShuttingDown = false;

    protected abstract void Run();

    public ThreadObject() {
        this(0x100000);
    }

    public ThreadObject(int iStackSize) {
        this.m_iStackSize = iStackSize;
        this.m_FinishedEvt = new ManualResetEvent(false);
        this.m_BeginShutdownEvt = new ManualResetEvent(false);
        this.m_ThreadCompleteEvt = new ManualResetEvent(false);
    }

    public boolean Destroy() {
        boolean bSuccess = false;
        bSuccess = this.Shutdown(true);
        if (this.m_FinishedEvt != null) {
            this.m_FinishedEvt = null;
        }
        if (this.m_BeginShutdownEvt != null) {
            this.m_BeginShutdownEvt = null;
        }
        if (this.m_ThreadCompleteEvt != null) {
            this.m_ThreadCompleteEvt = null;
        }
        return bSuccess;
    }

    public boolean IsRunning() {
        return this.isAlive();
    }

    public boolean IsShutdownRequested() {
        return this.m_bShuttingDown;
    }

    public boolean Start() {
        if (!this.m_bRunning) {
            this.m_bRunning = true;
            this.start();
            return true;
        }
        return false;
    }

    @Override
    public void run() {
        this.Run();
        this.m_ThreadCompleteEvt.set();
        this.OnThreadComplete();
    }

    protected void OnThreadComplete() {
    }

    public boolean Shutdown() {
        return this.Shutdown(true);
    }

    public boolean Shutdown(boolean bWait) {
        if (this.m_bShuttingDown || !this.m_bRunning) {
            return false;
        }
        this.m_bShuttingDown = true;
        this.m_BeginShutdownEvt.set();
        if (bWait) {
            this.WaitForShutdownComplete();
        } else {
            this.m_bShuttingDown = true;
        }
        return true;
    }

    public void WaitForShutdownComplete() {
        if (this.m_bRunning) {
            try {
                this.m_ThreadCompleteEvt.waitOne();
                int iShutdownAttempts = 0;
                while (this.isAlive()) {
                    Thread.sleep(iShutdownAttempts << 7);
                    ++iShutdownAttempts;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.m_bRunning = false;
            this.m_bShuttingDown = false;
        }
    }

    protected boolean WaitOnEvent(ManualResetEvent evt) {
        try {
            while (!evt.waitOne(500L) && !this.m_bShuttingDown) {
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !this.m_bShuttingDown;
    }
}

