/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.toolbox;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class WebMiscFuncs {
    public static String SerialiseToJson(Object obj) {
        String str = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            str = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            str = null;
        }
        return str;
    }

    public static <T> T DeserialiseFromJson(String jsonStr, Class<T> valueType) {
        Object retObj = null;
        try {
            ObjectMapper mapper = new ObjectMapper();
            retObj = mapper.readValue(jsonStr, valueType);
        }
        catch (IOException e) {
            retObj = null;
        }
        return (T)retObj;
    }

    public static <T> boolean PostToServerAsync(String url, Object obj, Class<T> responseType) {
        boolean bSuccess = false;
        try {
            class AsyncTask
            implements Runnable {
                String url = "";
                Object obj = null;
                Class<T> responseType = null;

                AsyncTask(String url, Object obj, Class<T> responseType) {
                    this.url = url;
                    this.obj = obj;
                    this.responseType = responseType;
                }

                @Override
                public void run() {
                    WebMiscFuncs.PostToServer(this.url, this.obj, this.responseType);
                }
            }
            new Thread(new AsyncTask(url, obj, responseType)).start();
            bSuccess = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bSuccess;
    }

    public static <T> T PostToServer(String url, Object obj, Class<T> responseType) {
        T ret = null;
        String jsonStr = WebMiscFuncs.SerialiseToJson(obj);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        HttpPost request = null;
        try {
            request = new HttpPost(url);
            request.addHeader("content-type", "application/json");
            if (jsonStr != null) {
                StringEntity params = new StringEntity(jsonStr);
                request.setEntity((HttpEntity)params);
            }
            ResponseHandler<String> responseHandler = new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    int status = response.getStatusLine().getStatusCode();
                    if (status >= 200 && status < 300) {
                        HttpEntity entity = response.getEntity();
                        return entity != null ? EntityUtils.toString((HttpEntity)entity) : null;
                    }
                    throw new ClientProtocolException("Unexpected response status: " + status);
                }
            };
            String responseStr = (String)httpClient.execute((HttpUriRequest)request, (ResponseHandler)responseHandler);
            ret = WebMiscFuncs.DeserialiseFromJson(responseStr, responseType);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret;
    }
}

