/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.toolbox;

import edu.uic.cs.nlp.toolbox.MiscFuncs;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XmlConfig {
    protected Object m_Proxy;
    protected String m_FileName = "";
    public String m_Content = null;

    public XmlConfig(Object obj) {
        this.m_Proxy = obj;
    }

    public XmlConfig() {
        this.m_Proxy = null;
    }

    public String GetFileName() {
        return this.m_FileName;
    }

    public void SetFileName(String fileName) {
        this.m_FileName = fileName;
    }

    public boolean Save() {
        return this.Save(this.m_FileName);
    }

    public boolean Save(String fileName) {
        if (fileName == null || fileName == "") {
            return false;
        }
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            boolean bSuccess;
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            String xml = "<?xml version='1.0'?><configuration></configuration>";
            InputSource is = new InputSource(new StringReader(xml));
            Document xmlDoc = dBuilder.parse(is);
            NodeList nodes = xmlDoc.getElementsByTagName("configuration");
            if (nodes != null && nodes.getLength() == 1 && (bSuccess = this.WriteSection(xmlDoc, nodes.item(0), null))) {
                File file = new File(fileName);
                String dir = file.getParent();
                if (!file.getParentFile().isDirectory()) {
                    file.getParentFile().mkdirs();
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                StreamResult output = new StreamResult(new File(fileName));
                DOMSource input = new DOMSource(xmlDoc);
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(input, output);
                this.m_FileName = fileName;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String toString() {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try {
            boolean bSuccess;
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            String xml = "<?xml version='1.0'?><configuration></configuration>";
            InputSource is = new InputSource(new StringReader(xml));
            Document xmlDoc = dBuilder.parse(is);
            NodeList nodes = xmlDoc.getElementsByTagName("configuration");
            if (nodes != null && nodes.getLength() == 1 && (bSuccess = this.WriteSection(xmlDoc, nodes.item(0), null))) {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                StringWriter writer = new StringWriter();
                DOMSource input = new DOMSource(xmlDoc);
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(input, new StreamResult(writer));
                return writer.toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public boolean FromString(String xml) {
        block3: {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            try {
                boolean bSuccess;
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                InputSource is = new InputSource(new StringReader(xml));
                Document xmlDoc = dBuilder.parse(is);
                NodeList nodes = xmlDoc.getElementsByTagName("configuration");
                if (nodes != null && nodes.getLength() == 1 && (bSuccess = this.ReadSection(xmlDoc, nodes.item(0)))) {
                    return bSuccess;
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return false;
    }

    public boolean Load() {
        return this.Load(this.m_FileName);
    }

    public boolean Load(String fileName) {
        block3: {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            try {
                boolean bSuccess;
                DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
                Document xmlDoc = dBuilder.parse(fileName);
                NodeList nodes = xmlDoc.getElementsByTagName("configuration");
                if (nodes != null && nodes.getLength() == 1 && (bSuccess = this.ReadSection(xmlDoc, nodes.item(0)))) {
                    this.m_FileName = fileName;
                    return bSuccess;
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
        return false;
    }

    public boolean ReadSection(Document xmlDoc, Node parent) throws IllegalArgumentException, IllegalAccessException, DOMException, ClassNotFoundException, InstantiationException, NoSuchMethodException, SecurityException, InvocationTargetException {
        Field[] fields;
        Class<?> thisType = this.m_Proxy == null ? this.getClass() : this.m_Proxy.getClass();
        Node primitivesNode = parent;
        Field[] fieldArray = fields = thisType.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.getName().indexOf("CFG_") == 0) {
                Node a;
                NamedNodeMap map;
                if (field.getType().isPrimitive() || field.getType().getName().endsWith(".String")) {
                    if (primitivesNode != null) {
                        map = primitivesNode.getAttributes();
                        int i = 0;
                        while (i < map.getLength()) {
                            a = map.item(i);
                            if (("CFG_" + a.getNodeName()).equalsIgnoreCase(field.getName())) {
                                String typeName = field.getType().getName();
                                String valStr = a.getNodeValue();
                                if (valStr != null) {
                                    Constable v;
                                    if (typeName.equals("java.lang.String")) {
                                        field.set(this, valStr);
                                    } else if (typeName.equals("int") || typeName.equals("int16") || typeName.equals("int32")) {
                                        v = MiscFuncs.IntTryParse(valStr);
                                        if (v != null) {
                                            field.setInt(this, (Integer)v);
                                        }
                                    } else if (typeName.equals("boolean")) {
                                        v = MiscFuncs.BoolTryParse(valStr);
                                        if (v != null) {
                                            field.setBoolean(this, (Boolean)v);
                                        }
                                    } else if (typeName.equals("byte")) {
                                        v = MiscFuncs.ByteTryParse(valStr);
                                        if (v != null) {
                                            field.setByte(this, (Byte)v);
                                        }
                                    } else if (typeName.equals("float")) {
                                        v = MiscFuncs.FloatTryParse(valStr);
                                        if (v != null) {
                                            field.setFloat(this, ((Float)v).floatValue());
                                        }
                                    } else if (typeName.equals("double")) {
                                        v = MiscFuncs.DoubleTryParse(valStr);
                                        if (v != null) {
                                            field.setDouble(this, (Double)v);
                                        }
                                    } else if (typeName.equals("long") && (v = MiscFuncs.LongTryParse(valStr)) != null) {
                                        field.setLong(this, (Long)v);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                } else if (field.getType().isEnum()) {
                    map = primitivesNode.getAttributes();
                    int i = 0;
                    while (i < map.getLength()) {
                        a = map.item(i);
                        if (("CFG_" + a.getNodeName()).equalsIgnoreCase(field.getName())) {
                            Object o = Enum.valueOf(field.getType(), a.getNodeValue());
                            field.set(this, o);
                        }
                        ++i;
                    }
                } else if (field.getClass() == Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig") || Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig").isAssignableFrom(field.getType())) {
                    NodeList childNodes = parent.getChildNodes();
                    int j = 0;
                    while (j < childNodes.getLength()) {
                        Node n3 = childNodes.item(j);
                        if (("CFG_" + n3.getNodeName()).equals(field.getName())) {
                            XmlConfig childObj = null;
                            Node typeNode = n3.getAttributes().getNamedItem("type");
                            if (typeNode != null) {
                                childObj = this.CreateObjectFromName(typeNode.getNodeValue());
                            }
                            if (childObj == null && field.getType() != Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig")) {
                                childObj = (XmlConfig)field.getType().newInstance();
                            }
                            if (childObj != null) {
                                childObj.ReadSection(xmlDoc, n3);
                                field.set(this, childObj);
                            }
                            break;
                        }
                        ++j;
                    }
                } else if (field.getClass() == Class.forName("java.util.List") || Class.forName("java.util.List").isAssignableFrom(field.getType())) {
                    NodeList childNodes;
                    Node a2;
                    int i;
                    Object list = Class.forName("java.util.ArrayList").newInstance();
                    Method addMethod = list.getClass().getMethod("add", Object.class);
                    ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                    Type[] genericTypes = paramType.getActualTypeArguments();
                    Type genericType = genericTypes[0];
                    String elementTypeName = ((Class)genericType).getName();
                    if (this.IsInlinableType(elementTypeName)) {
                        if (primitivesNode != null) {
                            NamedNodeMap map2 = primitivesNode.getAttributes();
                            i = 0;
                            while (i < map2.getLength()) {
                                a2 = map2.item(i);
                                if (("CFG_" + a2.getNodeName()).equalsIgnoreCase(field.getName())) {
                                    String arrayStr = a2.getNodeValue();
                                    if (arrayStr == null) break;
                                    Vector<String> elements = MiscFuncs.ParseString(arrayStr, ',');
                                    for (String s : elements) {
                                        Constable v;
                                        if ((s.equals("java.lang.Short") || s.equals("java.lang.Integer")) && (v = MiscFuncs.IntTryParse(s)) != null) {
                                            addMethod.invoke(list, v);
                                        }
                                        if (s.equals("java.lang.Boolean") && (v = MiscFuncs.BoolTryParse(s)) != null) {
                                            addMethod.invoke(list, v);
                                        }
                                        if (s.equals("java.lang.Byte") && (v = MiscFuncs.ByteTryParse(s)) != null) {
                                            addMethod.invoke(list, v);
                                        }
                                        if (s.equals("java.lang.Float") && (v = MiscFuncs.FloatTryParse(s)) != null) {
                                            addMethod.invoke(list, v);
                                        }
                                        if (s.equals("java.lang.Double") && (v = MiscFuncs.DoubleTryParse(s)) != null) {
                                            addMethod.invoke(list, v);
                                        }
                                        if (!s.equals("java.lang.Long") || (v = MiscFuncs.LongTryParse(s)) == null) continue;
                                        addMethod.invoke(list, v);
                                    }
                                    break;
                                }
                                ++i;
                            }
                        }
                    } else if (elementTypeName.equals("java.lang.String")) {
                        childNodes = parent.getChildNodes();
                        i = 0;
                        while (i < childNodes.getLength()) {
                            a2 = childNodes.item(i);
                            if (("CFG_" + a2.getNodeName()).equalsIgnoreCase(field.getName())) {
                                String str = a2.getAttributes().item(0).getNodeValue();
                                addMethod.invoke(list, str);
                            }
                            ++i;
                        }
                    } else if (genericType.equals(Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig")) || Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig").isAssignableFrom((Class)genericType)) {
                        childNodes = parent.getChildNodes();
                        i = 0;
                        while (i < childNodes.getLength()) {
                            Node n4 = childNodes.item(i);
                            if (("CFG_" + n4.getNodeName()).equals(field.getName())) {
                                XmlConfig childObj = null;
                                Node typeNode = n4.getAttributes().getNamedItem("type");
                                if (typeNode != null) {
                                    childObj = this.CreateObjectFromName(typeNode.getNodeValue());
                                }
                                if (childObj == null && field.getType() != Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig")) {
                                    childObj = (XmlConfig)((Class)genericType).newInstance();
                                }
                                if (childObj != null) {
                                    childObj.ReadSection(xmlDoc, n4);
                                    addMethod.invoke(list, childObj);
                                }
                            }
                            ++i;
                        }
                    }
                    field.set(this, list);
                }
            }
            ++n2;
        }
        this.m_Content = null;
        Node child = parent.getFirstChild();
        while (child != null && this.m_Content == null) {
            if (child.getNodeType() == 3 && child.getNodeValue().trim().length() > 0) {
                this.m_Content = child.getNodeValue().trim();
            }
            child = child.getNextSibling();
        }
        return true;
    }

    public boolean WriteSection(Document xmlDoc, Node parent, Type fieldType) throws ClassNotFoundException, DOMException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Field[] fields;
        Class<?> thisType;
        Class<?> clazz = thisType = this.m_Proxy == null ? this.getClass() : this.m_Proxy.getClass();
        if (fieldType != null && !((Class)fieldType).getName().equals(thisType.getName())) {
            ((Element)parent).setAttribute("type", thisType.getName());
        }
        if (this.m_Content != null) {
            xmlDoc.createTextNode(this.m_Content);
        }
        Node primitiveNode = parent;
        Field[] fieldArray = fields = thisType.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Object val;
            Field field = fieldArray[n2];
            if (field.getName().startsWith("CFG_") && (val = field.get(this)) != null) {
                List arr;
                String outFieldName = field.getName().substring(4);
                if (field.getType().isPrimitive() || field.getType().getName().equals("java.lang.String") || field.getType().isEnum()) {
                    ((Element)primitiveNode).setAttribute(outFieldName, val.toString());
                } else if (field.getClass() == Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig") || Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig").isAssignableFrom(field.getType())) {
                    Element subNode = xmlDoc.createElement(outFieldName);
                    parent.appendChild(subNode);
                    XmlConfig childObj = (XmlConfig)val;
                    if (childObj != null) {
                        childObj.WriteSection(xmlDoc, subNode, field.getType());
                    }
                } else if ((field.getClass() == Class.forName("java.util.List") || Class.forName("java.util.List").isAssignableFrom(field.getType())) && (arr = (List)val).size() > 0) {
                    Node node;
                    ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                    Type[] genericTypes = paramType.getActualTypeArguments();
                    Type arrType = genericTypes[0];
                    String arrTypeName = ((Class)arrType).getName();
                    if (this.IsInlinableType(arrTypeName) || field.getClass().isEnum()) {
                        for (Object obj : arr) {
                            node = primitiveNode.getAttributes().getNamedItem(outFieldName);
                            if (node == null) {
                                ((Element)parent).setAttribute(outFieldName, obj.toString());
                                continue;
                            }
                            node.setNodeValue(String.valueOf(node.getNodeValue()) + "," + obj.toString());
                        }
                    } else {
                        for (Object obj : arr) {
                            if (obj == null) continue;
                            node = xmlDoc.createElement(outFieldName);
                            if (arrTypeName.equals("java.lang.String")) {
                                node.setAttribute("value", obj.toString());
                            } else if (arrTypeName.equals(Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig")) || Class.forName("edu.uic.cs.nlp.toolbox.XmlConfig").isAssignableFrom((Class)arrType)) {
                                Element subNode = xmlDoc.createElement(outFieldName);
                                XmlConfig childObj = (XmlConfig)obj;
                                childObj.WriteSection(xmlDoc, node, arrType);
                            }
                            parent.appendChild(node);
                        }
                    }
                }
            }
            ++n2;
        }
        return true;
    }

    private XmlConfig CreateObjectFromName(String typeName) {
        XmlConfig obj = null;
        try {
            Class<?> c = Class.forName(typeName);
            obj = (XmlConfig)c.newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return obj;
    }

    private boolean IsInlinableType(String elementTypeName) {
        return elementTypeName.equals("java.lang.Integer") || elementTypeName.equals("java.lang.Short") || elementTypeName.equals("java.lang.Double") || elementTypeName.equals("java.lang.Float") || elementTypeName.equals("java.lang.Byte") || elementTypeName.equals("java.lang.Long") || elementTypeName.equals("java.lang.Boolean");
    }
}

