/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.ui.graph;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Line;

public class ArrowHeadLine
extends Line {
    public ImageView m_StartImage = null;
    public ImageView m_EndImage = null;

    public ArrowHeadLine(ImageView startImage, ImageView endImage) {
        ChangeListener<Object> listener = new ChangeListener<Object>(){

            public void changed(ObservableValue<?> arg0, Object arg1, Object arg2) {
                ArrowHeadLine.this.OnLineChanged();
            }
        };
        this.startXProperty().addListener((ChangeListener)listener);
        this.startYProperty().addListener((ChangeListener)listener);
        this.endXProperty().addListener((ChangeListener)listener);
        this.endYProperty().addListener((ChangeListener)listener);
        this.m_StartImage = startImage;
        this.m_EndImage = endImage;
    }

    private void OnLineChanged() {
        double dAngle = 0.0;
        if (this.m_StartImage != null || this.m_EndImage != null) {
            double dXDelta = this.getStartX() - this.getEndX();
            double dYDelta = this.getStartY() - this.getEndY();
            dAngle = Math.atan2(dYDelta, dXDelta) * 180.0 / Math.PI + 270.0;
            if (dAngle > 360.0) {
                dAngle -= 360.0;
            }
            if (this.m_StartImage != null) {
                this.m_StartImage.setLayoutX(this.getStartX() - this.m_StartImage.getFitWidth() / 2.0);
                this.m_StartImage.setLayoutY(this.getStartY() - this.m_StartImage.getFitHeight() / 2.0);
                this.m_StartImage.setRotate(dAngle - 180.0);
            }
            if (this.m_EndImage != null) {
                this.m_EndImage.setLayoutX(this.getEndX() - this.m_EndImage.getFitWidth() / 2.0);
                this.m_EndImage.setLayoutY(this.getEndY() - this.m_EndImage.getFitHeight() / 2.0);
                this.m_EndImage.setRotate(dAngle);
            }
        }
    }

    public void Delete() {
        if (this.m_EndImage != null) {
            ((Pane)this.m_EndImage.getParent()).getChildren().remove((Object)this.m_EndImage);
        }
        if (this.m_StartImage != null) {
            ((Pane)this.m_StartImage.getParent()).getChildren().remove((Object)this.m_StartImage);
        }
    }
}

