/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.ui.graph;

import edu.uic.cs.nlp.ui.graph.ArrowHeadLine;
import edu.uic.cs.nlp.ui.graph.DefaultNodeCentreCtrl;
import edu.uic.cs.nlp.ui.graph.DefaultNodeConnectorCtrl;
import edu.uic.cs.nlp.ui.graph.FxGraphComponentInfo;
import edu.uic.cs.nlp.ui.graph.FxGraphNode;
import edu.uic.cs.nlp.ui.graph.FxGraphNodeDef;
import edu.uic.cs.nlp.ui.graph.GraphEventType;
import edu.uic.cs.nlp.ui.graph.IFxGraphEventHandler;
import edu.uic.cs.nlp.ui.graph.INodeConnectorCtrl;
import edu.uic.cs.nlp.ui.graph.NodeConnection;
import edu.uic.cs.nlp.ui.graph.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;

public class FxGraphCtrl
extends Pane
implements IFxGraphEventHandler,
EventHandler<MouseEvent> {
    protected Text m_TextBlock = null;
    public static final int CreateFlag_None = 0;
    public static final int CreateFlag_TopDown = 1;
    public static final int CreateFlag_LeftRight = 2;
    public static final int CreateFlag_Movable = 128;
    public static final int CreateFlag_Connectable = 256;
    public static final int CreateFlag_Bidirectional = 512;
    public static final int CreateFlag_Cyclic = 1024;
    public static final int CreateFlag_Default = 0;
    protected int m_iCreateFlags = 0;
    protected Class m_NodeType = DefaultNodeCentreCtrl.class;
    protected Class m_ConnectorType = DefaultNodeConnectorCtrl.class;
    protected List<FxGraphNode> m_Nodes = new ArrayList<FxGraphNode>();
    protected HashMap<Integer, ImageSet> m_ImageSets = new HashMap();
    protected Image m_ConnectionArrow = null;
    protected double m_dDragControlOffsetX = 0.0;
    protected double m_dDragControlOffsetY = 0.0;
    protected IFxGraphEventHandler m_GraphEventHandler = null;
    protected List<NodeConnection> m_Connections = new ArrayList<NodeConnection>();
    private EventHandler<MouseEvent> m_BackgoundMouseEvtHandler = new EventHandler<MouseEvent>(){

        public void handle(MouseEvent event) {
            FxGraphCtrl.this.OnMouseClicked(event);
        }
    };

    public FxGraphCtrl(int iCreateFlags) {
        this.m_iCreateFlags = iCreateFlags;
        this.setOnMouseClicked(this.m_BackgoundMouseEvtHandler);
    }

    protected void OnMouseClicked(MouseEvent event) {
        if (event.getTarget() == this) {
            this.OnBackgroundClicked(event);
        }
    }

    public void SetNodeType(Class c) {
        this.m_NodeType = c;
    }

    public void SetGraphEventHandler(IFxGraphEventHandler graphEventHandler) {
        this.m_GraphEventHandler = graphEventHandler;
    }

    public FxGraphNode CreateNode(FxGraphNodeDef def) {
        ImageSet imageSet = null;
        if (this.m_ImageSets.containsKey(def.m_iImageSetId)) {
            imageSet = this.m_ImageSets.get(def.m_iImageSetId);
        }
        FxGraphNode ctrl = null;
        ctrl = imageSet == null ? FxGraphNode.CreateNode(this.m_NodeType, this.m_ConnectorType, def, null, null, null, null) : FxGraphNode.CreateNode(this.m_NodeType, this.m_ConnectorType, def, imageSet.m_NodeCentre, imageSet.m_NodeCentreSel, imageSet.m_Connector, imageSet.m_ConnectorSel);
        ctrl.SetGraphEventHandler(this);
        ctrl.setLayoutX(def.m_iLeft);
        ctrl.setLayoutY(def.m_iTop);
        ctrl.resize(def.m_iWidth, def.m_iHeight);
        ctrl.onMousePressedProperty().set((Object)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FxGraphNode srcCtrl = (FxGraphNode)((Object)event.getSource());
                FxGraphCtrl.this.m_dDragControlOffsetX = event.getSceneX() - srcCtrl.getLayoutX();
                FxGraphCtrl.this.m_dDragControlOffsetY = event.getSceneY() - srcCtrl.getLayoutY();
            }
        });
        ctrl.onMouseDraggedProperty().set((Object)this);
        return ctrl;
    }

    public FxGraphNode AddGraphNode(FxGraphNodeDef def) {
        FxGraphNode ctrl = this.CreateNode(def);
        this.m_Nodes.add(ctrl);
        this.getChildren().add(0, (Object)ctrl);
        return ctrl;
    }

    public void handle(MouseEvent event) {
        double dNewY;
        FxGraphNode srcCtrl = (FxGraphNode)((Object)event.getSource());
        double dNewX = event.getSceneX() - this.m_dDragControlOffsetX;
        if (dNewX < 0.0) {
            dNewX = 0.0;
        }
        if (dNewX > this.getWidth() - srcCtrl.getWidth()) {
            dNewX = this.getWidth() - srcCtrl.getWidth();
        }
        if ((dNewY = event.getSceneY() - this.m_dDragControlOffsetY) < 0.0) {
            dNewY = 0.0;
        }
        if (dNewY > this.getHeight() - srcCtrl.getHeight()) {
            dNewY = this.getHeight() - srcCtrl.getHeight();
        }
        srcCtrl.setLayoutX(dNewX);
        srcCtrl.setLayoutY(dNewY);
        this.UpdateAllConnectionPositions();
        this.OnNodeMoved(srcCtrl, dNewX, dNewY);
    }

    public void OnNodeMoved(FxGraphNode node, double x, double y) {
    }

    public void SetImages(Image nodeCentre, Image nodeCentreSel, Image connector, Image connectorSel, int iImageSetId) {
        ImageSet set = new ImageSet();
        set.m_NodeCentre = nodeCentre;
        set.m_NodeCentreSel = nodeCentreSel;
        set.m_Connector = connector;
        set.m_ConnectorSel = connectorSel;
        this.m_ImageSets.put(iImageSetId, set);
    }

    public void SetConnectionImage(Image connectionArrow) {
        this.m_ConnectionArrow = connectionArrow;
    }

    public void DeselectAllNodeConnections() {
        for (FxGraphNode node : this.m_Nodes) {
            Node[] nodeArray = node.m_Connectors;
            int n = node.m_Connectors.length;
            int n2 = 0;
            while (n2 < n) {
                Node n3 = nodeArray[n2];
                ((INodeConnectorCtrl)n3).SetSelected(false);
                ++n2;
            }
        }
    }

    @Override
    public void OnNodeConnectorClicked(Object sender, FxGraphComponentInfo info) {
        FxGraphNode node = (FxGraphNode)((Object)sender);
        INodeConnectorCtrl con = node.GetConnector(info.m_iConnectorId);
        boolean bOriginalState = con.GetState().IsSelected();
        this.DeselectAllNodeConnections();
        con.SetSelected(!bOriginalState);
        this.m_GraphEventHandler.OnGraphEvent(this, !bOriginalState ? GraphEventType.NodeConnectorSelected : GraphEventType.NodeConnectorDeselected, info);
    }

    @Override
    public void OnNodeClicked(Object sender, FxGraphComponentInfo info) {
        this.OnNodeSelected((FxGraphNode)((Object)sender));
    }

    @Override
    public void OnBackgroundClicked(Object sender) {
    }

    private void OnNodeSelected(FxGraphNode sender) {
    }

    public void AddConnection(FxGraphComponentInfo src, FxGraphComponentInfo dest, boolean bidirectional) {
        INodeConnectorCtrl srcCtrl = this.GetConnectionById(src.m_iNodeId, src.m_iConnectorId);
        INodeConnectorCtrl destCtrl = this.GetConnectionById(dest.m_iNodeId, dest.m_iConnectorId);
        boolean bExists = false;
        for (NodeConnection con : this.m_Connections) {
            if (!con.m_SrcInfo.IsEqual(src) || !con.m_DestInfo.IsEqual(dest)) continue;
            bExists = true;
            break;
        }
        if (!bExists) {
            NodeConnection con;
            con = new NodeConnection();
            con.m_SrcInfo = new FxGraphComponentInfo(src);
            con.m_DestInfo = new FxGraphComponentInfo(dest);
            con.m_LineCtrl = new ArrowHeadLine(null, this.AddArrowHead());
            this.m_Connections.add(con);
            this.getChildren().add((Object)con.m_LineCtrl);
            this.UpdateAllConnectionPositions();
        }
    }

    public ImageView AddArrowHead() {
        ImageView imageView = new ImageView();
        imageView.setImage(this.m_ConnectionArrow);
        imageView.setFitWidth(20.0);
        imageView.setFitHeight(20.0);
        this.getChildren().add((Object)imageView);
        return imageView;
    }

    public void RemoveConnection(NodeConnection con) {
        this.RemoveConnection(con.m_SrcInfo, con.m_DestInfo);
    }

    public void RemoveConnection(FxGraphComponentInfo src, FxGraphComponentInfo dest) {
        int i = 0;
        while (i < this.m_Connections.size()) {
            NodeConnection c = this.m_Connections.get(i);
            if (c != null && c.m_SrcInfo.equals(src) && c.m_DestInfo.equals(dest)) {
                c.m_LineCtrl.Delete();
                this.getChildren().remove((Object)c.m_LineCtrl);
                this.m_Connections.remove(i);
                --i;
            }
            ++i;
        }
        this.UpdateAllConnectionPositions();
    }

    protected void UpdateAllConnectionPositions() {
        for (NodeConnection con : this.m_Connections) {
            INodeConnectorCtrl srcCtrl = this.GetConnectionById(con.m_SrcInfo.m_iNodeId, con.m_SrcInfo.m_iConnectorId);
            INodeConnectorCtrl destCtrl = this.GetConnectionById(con.m_DestInfo.m_iNodeId, con.m_DestInfo.m_iConnectorId);
            if (srcCtrl == null || destCtrl == null) continue;
            Point srcPnt = srcCtrl.GetPosition();
            srcPnt.m_iX = (int)((double)srcPnt.m_iX + ((double)((int)(((Pane)srcCtrl).getWidth() / 2.0)) + srcCtrl.GetState().m_Owner.getLayoutX()));
            srcPnt.m_iY = (int)((double)srcPnt.m_iY + ((double)((int)(((Pane)srcCtrl).getHeight() / 2.0)) + srcCtrl.GetState().m_Owner.getLayoutY()));
            Point destPnt = destCtrl.GetPosition();
            destPnt.m_iX = (int)((double)destPnt.m_iX + ((double)((int)(((Pane)destCtrl).getWidth() / 2.0)) + destCtrl.GetState().m_Owner.getLayoutX()));
            destPnt.m_iY = (int)((double)destPnt.m_iY + ((double)((int)(((Pane)destCtrl).getHeight() / 2.0)) + destCtrl.GetState().m_Owner.getLayoutY()));
            con.m_LineCtrl.setStartX(srcPnt.m_iX);
            con.m_LineCtrl.setStartY(srcPnt.m_iY);
            con.m_LineCtrl.setEndX(destPnt.m_iX);
            con.m_LineCtrl.setEndY(destPnt.m_iY);
        }
    }

    public FxGraphNode GetNodeById(int iId) {
        for (FxGraphNode node : this.m_Nodes) {
            if (node.m_NodeDef.m_iNodeId != iId) continue;
            return node;
        }
        return null;
    }

    public INodeConnectorCtrl GetConnectionById(int iNodeId, int iConnectorId) {
        FxGraphNode node = this.GetNodeById(iNodeId);
        if (node != null) {
            return node.GetConnector(iConnectorId);
        }
        return null;
    }

    public List<FxGraphNode> GetNodes() {
        return this.m_Nodes;
    }

    public List<FxGraphNode> GetNodeListCopy() {
        ArrayList<FxGraphNode> ret = new ArrayList<FxGraphNode>();
        for (FxGraphNode n : this.m_Nodes) {
            ret.add(n);
        }
        return ret;
    }

    public void RemoveNode(FxGraphNode node) {
        int i = 0;
        while (i < this.m_Nodes.size()) {
            if (this.m_Nodes.get(i) == node) {
                this.getChildren().remove((Object)node);
                this.m_Nodes.remove(i);
                --i;
            }
            ++i;
        }
        i = 0;
        while (i < this.m_Connections.size()) {
            if (this.m_Connections.get((int)i).m_SrcInfo.m_iNodeId == node.GetNodeId() || this.m_Connections.get((int)i).m_DestInfo.m_iNodeId == node.GetNodeId()) {
                this.RemoveConnection(this.m_Connections.get(i));
                --i;
            }
            ++i;
        }
    }

    public void Clear() {
        while (this.m_Nodes.size() > 0) {
            this.RemoveNode(this.m_Nodes.get(0));
        }
    }

    @Override
    public void OnGraphEvent(Object sender, GraphEventType evtType, FxGraphComponentInfo info) {
    }

    public class ImageSet {
        protected Image m_NodeCentre = null;
        protected Image m_NodeCentreSel = null;
        protected Image m_Connector = null;
        protected Image m_ConnectorSel = null;
    }
}

