/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.ui.graph;

import edu.uic.cs.nlp.ui.graph.Connector;
import edu.uic.cs.nlp.ui.graph.FPoint;
import edu.uic.cs.nlp.ui.graph.FxGraphComponentInfo;
import edu.uic.cs.nlp.ui.graph.FxGraphNodeDef;
import edu.uic.cs.nlp.ui.graph.GraphEventType;
import edu.uic.cs.nlp.ui.graph.IFxGraphEventHandler;
import edu.uic.cs.nlp.ui.graph.INodeCentreCtrl;
import edu.uic.cs.nlp.ui.graph.INodeConnectorCtrl;
import edu.uic.cs.nlp.ui.graph.Point;
import edu.uic.cs.nlp.ui.graph.Size;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.event.EventHandler;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.effect.ColorAdjust;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.util.Duration;

public class FxGraphNode
extends Pane
implements EventHandler<MouseEvent> {
    protected Class m_NodeType = null;
    protected Class m_ConnectorType = null;
    protected Node m_Node = null;
    protected Node[] m_Connectors = null;
    protected FxGraphNodeDef m_NodeDef = null;
    protected Size m_ConnectorSize = new Size(8, 8);
    protected Image m_NodeCentre = null;
    protected Image m_NodeCentreSel = null;
    protected Image m_Connector = null;
    protected Image m_ConnectorSel = null;
    protected IFxGraphEventHandler m_GraphEventHandler = null;
    protected Timeline m_SizeTimeline = new Timeline();
    protected ColorAdjust m_BrightnessAdjust = new ColorAdjust();
    protected Timeline m_BrightnessTimeline = new Timeline();
    protected Timeline m_RevBrightnessTimeline = new Timeline();

    public void SetGraphEventHandler(IFxGraphEventHandler graphEventHandler) {
        this.m_GraphEventHandler = graphEventHandler;
    }

    public FxGraphNodeDef GetNodeDef() {
        return this.m_NodeDef;
    }

    private boolean Init(Class nodeType, Class connectorType, FxGraphNodeDef def, Image nodeCentre, Image nodeCentreSel, Image connector, Image connectorSel) {
        this.m_NodeCentre = nodeCentre;
        this.m_NodeCentreSel = nodeCentreSel;
        this.m_Connector = connector;
        this.m_ConnectorSel = connectorSel;
        this.m_NodeType = nodeType;
        this.m_ConnectorType = connectorType;
        this.m_NodeDef = def;
        try {
            Object obj = this.m_NodeType.newInstance();
            this.m_Node = (Node)obj;
            ((INodeCentreCtrl)this.m_Node).Init();
            ((INodeCentreCtrl)this.m_Node).SetSize(def.m_iWidth, def.m_iHeight);
            ((INodeCentreCtrl)this.m_Node).SetText(def.m_Text);
            ((INodeCentreCtrl)this.m_Node).SetOwner(this);
            ((INodeCentreCtrl)this.m_Node).SetTextArea(def.m_TextArea);
            ((INodeCentreCtrl)this.m_Node).SetImage(nodeCentre, nodeCentreSel);
            this.getChildren().add((Object)this.m_Node);
            this.m_Node.onMouseClickedProperty().set((Object)this);
            this.m_Node.onMouseClickedProperty().set((Object)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    FxGraphNode.this.OnMouseEvent(event);
                }
            });
            this.m_SizeTimeline.setCycleCount(-1);
            this.m_SizeTimeline.setAutoReverse(true);
            KeyValue kvX = new KeyValue((WritableValue)this.m_Node.scaleXProperty(), (Object)1.2, Interpolator.EASE_BOTH);
            KeyFrame kfX = new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{kvX});
            KeyValue kvY = new KeyValue((WritableValue)this.m_Node.scaleYProperty(), (Object)1.2, Interpolator.EASE_BOTH);
            KeyFrame kfY = new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{kvY});
            this.m_SizeTimeline.getKeyFrames().add((Object)kfX);
            this.m_SizeTimeline.getKeyFrames().add((Object)kfY);
            ColorAdjust brightnessAdjust = new ColorAdjust();
            brightnessAdjust.setBrightness(0.0);
            ImageView imgView = ((INodeCentreCtrl)this.m_Node).GetImageView();
            imgView.setEffect((Effect)brightnessAdjust);
            imgView.setCache(true);
            imgView.setCacheHint(CacheHint.SPEED);
            this.m_BrightnessTimeline.setCycleCount(-1);
            this.m_BrightnessTimeline.setAutoReverse(true);
            KeyValue kvXA = new KeyValue((WritableValue)brightnessAdjust.brightnessProperty(), (Object)0.5, Interpolator.EASE_BOTH);
            KeyFrame kfXA = new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{kvXA});
            this.m_BrightnessTimeline.getKeyFrames().add((Object)kfXA);
            this.m_RevBrightnessTimeline.setCycleCount(1);
            KeyFrame revBrightKf = new KeyFrame(Duration.millis((double)400.0), new KeyValue[]{new KeyValue((WritableValue)brightnessAdjust.brightnessProperty(), (Object)0.0, Interpolator.EASE_BOTH)});
            this.m_RevBrightnessTimeline.getKeyFrames().add((Object)revBrightKf);
            this.m_Connectors = new Node[def.m_Connectors.size()];
            int i = 0;
            while (i < this.m_Connectors.length) {
                Connector conDef = def.m_Connectors.get(i);
                int iConnectorWidth = 12;
                int iConnectorHeight = 12;
                this.m_Connectors[i] = (Node)this.m_ConnectorType.newInstance();
                ((INodeConnectorCtrl)this.m_Connectors[i]).Init();
                ((INodeConnectorCtrl)this.m_Connectors[i]).SetImage(connector, connectorSel);
                ((INodeConnectorCtrl)this.m_Connectors[i]).SetSize(iConnectorWidth, iConnectorHeight);
                ((INodeConnectorCtrl)this.m_Connectors[i]).GetState().SetIndex(i);
                ((INodeConnectorCtrl)this.m_Connectors[i]).GetState().SetOwner(this);
                this.getChildren().add((Object)this.m_Connectors[i]);
                Point pnt = new Point();
                pnt.m_iX = (int)((float)def.m_iWidth * conDef.m_Position.m_fX) - (iConnectorWidth >> 1);
                pnt.m_iY = (int)((float)def.m_iHeight * conDef.m_Position.m_fY) - (iConnectorHeight >> 1);
                this.m_Connectors[i].setLayoutX((double)pnt.m_iX);
                this.m_Connectors[i].setLayoutY((double)pnt.m_iY);
                this.m_Connectors[i].onMouseClickedProperty().set((Object)this);
                ++i;
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return true;
    }

    protected void OnMouseEvent(MouseEvent event) {
        INodeCentreCtrl ctrl = (INodeCentreCtrl)event.getSource();
        if (this.m_GraphEventHandler != null) {
            this.m_GraphEventHandler.OnGraphEvent((Object)this, GraphEventType.NodeClicked, new FxGraphComponentInfo(ctrl.GetOwner().GetNodeId()));
            this.m_GraphEventHandler.OnNodeClicked((Object)this, new FxGraphComponentInfo(ctrl.GetOwner().GetNodeId()));
        }
    }

    public void handle(MouseEvent event) {
        INodeConnectorCtrl ctrl = (INodeConnectorCtrl)event.getSource();
        if (this.m_GraphEventHandler != null) {
            this.m_GraphEventHandler.OnGraphEvent((Object)this, GraphEventType.NodeConnectorClicked, new FxGraphComponentInfo(this.GetNodeId(), ctrl.GetState().GetIndex()));
        }
    }

    public static FxGraphNode CreateNode(Class nodeType, Class connectorType, FxGraphNodeDef def, Image nodeCentre, Image nodeCentreSel, Image connector, Image connectorSel) {
        FxGraphNode node = new FxGraphNode();
        if (!node.Init(nodeType, connectorType, def, nodeCentre, nodeCentreSel, connector, connectorSel)) {
            node = null;
        }
        return node;
    }

    public INodeConnectorCtrl GetConnector(int iComponentId) {
        Node[] nodeArray = this.m_Connectors;
        int n = this.m_Connectors.length;
        int n2 = 0;
        while (n2 < n) {
            Node con = nodeArray[n2];
            if (((INodeConnectorCtrl)con).GetState().GetIndex() == iComponentId) {
                return (INodeConnectorCtrl)con;
            }
            ++n2;
        }
        return null;
    }

    public int GetNodeId() {
        return this.m_NodeDef.m_iNodeId;
    }

    public int GetConnectorIdByTag(int iTag) {
        int i = 0;
        while (i < this.m_NodeDef.m_Connectors.size()) {
            if (this.m_NodeDef.m_Connectors.get((int)i).m_iTag == iTag) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int GetConnectorIdAtPosition(FPoint pnt) {
        int i = 0;
        while (i < this.m_NodeDef.m_Connectors.size()) {
            FPoint conPos = this.m_NodeDef.m_Connectors.get((int)i).m_Position;
            if (conPos.m_fX == pnt.m_fX && conPos.m_fY == pnt.m_fY) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void SetNodeName(String nameStr) {
        ((INodeCentreCtrl)this.m_Node).SetText(nameStr);
    }

    public void SetSize(double dWidth, double dHeight) {
        ((INodeCentreCtrl)this.m_Node).SetSize((int)dWidth, (int)dHeight);
        this.setPrefSize(dWidth, dHeight);
    }

    public void Highlight(boolean bSet, boolean bPulse, boolean bSize, boolean bBrightness) {
        if (bSet) {
            if (bSize) {
                this.m_SizeTimeline.stop();
            }
            if (bBrightness) {
                this.m_BrightnessTimeline.stop();
            }
            this.m_SizeTimeline.setCycleCount(bPulse ? -1 : 1);
            this.m_SizeTimeline.setAutoReverse(bPulse);
            this.m_BrightnessTimeline.setCycleCount(bPulse ? -1 : 1);
            this.m_BrightnessTimeline.setAutoReverse(bPulse);
            if (bSize) {
                this.m_SizeTimeline.play();
            }
            if (bBrightness) {
                this.m_BrightnessTimeline.play();
            }
        } else {
            this.m_SizeTimeline.jumpTo(Duration.ZERO);
            this.m_SizeTimeline.stop();
            this.m_BrightnessTimeline.jumpTo(Duration.ZERO);
            this.m_BrightnessTimeline.stop();
            this.m_RevBrightnessTimeline.play();
        }
    }
}

