/*
 * Decompiled with CFR 0.152.
 */
package edu.uic.cs.nlp.ui.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javafx.scene.image.Image;

public class ImageCache {
    protected Map<String, ImageInfo> m_Images = new HashMap<String, ImageInfo>();
    protected List<Alias> m_AliasLookup = new ArrayList<Alias>();

    public boolean Init() {
        return true;
    }

    public boolean Destroy() {
        this.RemoveAllImages();
        return true;
    }

    public boolean RemoveAllImages() {
        Set<String> keys = this.m_Images.keySet();
        for (String key : keys) {
            ImageInfo info = this.m_Images.get(key);
            info.m_Image = null;
        }
        this.m_Images.clear();
        this.m_AliasLookup.clear();
        return true;
    }

    public boolean RemoveImage(int iId) {
        ImageInfo info = this.GetImageInfo(iId);
        if (info != null) {
            this.RemoveImage(info.m_FileName);
            return true;
        }
        return false;
    }

    public boolean RemoveAlias(int iId) {
        int i = 0;
        while (i < this.m_AliasLookup.size()) {
            if (this.m_AliasLookup.get((int)i).m_iId == iId) {
                this.m_AliasLookup.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean RemoveImage(String fileName) {
        if (this.m_Images.containsKey(fileName)) {
            ImageInfo info = this.m_Images.get(fileName);
            info.m_Image = null;
            this.m_Images.remove(fileName);
            int i = this.m_AliasLookup.size() - 1;
            while (i >= 0) {
                if (this.m_AliasLookup.get((int)i).m_Info == info) {
                    this.m_AliasLookup.remove(i);
                }
                --i;
            }
        }
        return true;
    }

    public Image GetImage(String fileName) {
        ImageInfo info = this.GetImageInfo(fileName, true);
        return info == null ? null : info.m_Image;
    }

    public Image GetImage(int iId) {
        ImageInfo info = this.GetImageInfo(iId);
        return info == null ? null : info.m_Image;
    }

    public boolean CreateAlias(String fileName, int iId) {
        ImageInfo info;
        if (this.IsAliasUsed(iId) && (info = this.GetImageInfo(fileName, false)) != null) {
            Alias a = new Alias();
            a.m_iId = iId;
            a.m_Info = info;
            this.m_AliasLookup.add(a);
            return true;
        }
        return false;
    }

    protected ImageInfo GetImageInfo(String fileName, boolean bLoad) {
        if (this.m_Images.containsKey(fileName)) {
            return this.m_Images.get(fileName);
        }
        if (bLoad) {
            return this.LoadImage(fileName);
        }
        return null;
    }

    protected ImageInfo GetImageInfo(int iId) {
        int i = 0;
        while (i < this.m_AliasLookup.size()) {
            if (this.m_AliasLookup.get((int)i).m_iId == iId) {
                return this.m_AliasLookup.get((int)i).m_Info;
            }
            ++i;
        }
        return null;
    }

    protected boolean IsAliasUsed(int iId) {
        int i = 0;
        while (i < this.m_AliasLookup.size()) {
            if (this.m_AliasLookup.get((int)i).m_iId == iId) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean PreloadImage(String fileName) {
        return this.PreloadImage(fileName, -1);
    }

    public boolean PreloadImage(String fileName, int iAlias) {
        ImageInfo info = this.LoadImage(fileName, iAlias);
        return info != null;
    }

    protected ImageInfo LoadImage(String fileName, int iAlias) {
        ImageInfo info = this.LoadImage(fileName, -1);
        if (info != null && !this.IsAliasUsed(iAlias)) {
            Alias a = new Alias();
            a.m_iId = iAlias;
            a.m_Info = info;
            this.m_AliasLookup.add(a);
        }
        return info;
    }

    protected ImageInfo LoadImage(String fileName) {
        if (!this.m_Images.containsKey(fileName)) {
            try {
                Image image = new Image(fileName);
                ImageInfo info = new ImageInfo();
                info.m_FileName = fileName;
                info.m_Image = image;
                this.m_Images.put(fileName, info);
                return info;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public class Alias {
        public int m_iId = 0;
        public ImageInfo m_Info = null;
    }

    public class ImageInfo {
        public Image m_Image = null;
        public int m_iLastAccessed = 0;
        public String m_FileName = "";
    }
}

