/*
 * Decompiled with CFR 0.152.
 */
package ilist.misc;

import java.io.Serializable;

public class StatisticalAggregator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int n = 0;
    private double m = 0.0;
    private double s = 0.0;
    private double sigma = 0.0;
    private double previousM = 0.0;
    private double previousSigma = 0.0;
    private double min = 0.0;
    private double max = 0.0;

    public void addSample(double x) {
        this.previousM = this.m;
        this.previousSigma = this.sigma;
        ++this.n;
        if (this.n == 1) {
            this.m = x;
            this.s = 0.0;
            this.min = x;
            this.max = x;
        } else {
            double m0 = this.m;
            this.m = m0 + (x - m0) / (double)this.n;
            this.s += (x - m0) * (x - this.m);
            this.sigma = Math.sqrt(this.s / (double)(this.n - 1));
            if (x > this.max) {
                this.max = x;
            } else if (x < this.min) {
                this.min = x;
            }
        }
    }

    public double mean() {
        return this.m;
    }

    public double stdev() {
        return this.sigma;
    }

    public double previousMean() {
        return this.previousM;
    }

    public double previousStdev() {
        return this.previousSigma;
    }

    public int numSamples() {
        return this.n;
    }

    public double min() {
        return this.min;
    }

    public double max() {
        return this.max;
    }

    public void clear() {
        this.n = 0;
        this.m = 0.0;
        this.s = 0.0;
        this.sigma = 0.0;
        this.previousM = 0.0;
        this.previousSigma = 0.0;
        this.min = 0.0;
        this.max = 0.0;
    }
}

