/*
 * Decompiled with CFR 0.152.
 */
package ilist.misc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import java.util.Scanner;
import java.util.Vector;
import javax.swing.ImageIcon;

public class Util {
    public static ImageIcon createImageIcon(String path, String description) {
        URL imgURL = ClassLoader.getSystemResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL, description);
        }
        System.err.println("Couldn't find file: " + path);
        return null;
    }

    public static byte[] streamToByteArray(InputStream in) {
        byte[] b = null;
        try {
            byte[] c;
            int len = 4096;
            b = new byte[len];
            int off = 0;
            int nread = 0;
            while ((nread = in.read(b, off, len - off)) > 0) {
                if ((off += nread) != len) continue;
                c = new byte[len *= 2];
                System.arraycopy(b, 0, c, 0, off);
                b = c;
            }
            if (off < len) {
                c = new byte[off];
                System.arraycopy(b, 0, c, 0, off);
                b = c;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return b;
    }

    public static String slurpFile(URL url) {
        String s = null;
        try {
            int c;
            BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
            StringBuilder sb = new StringBuilder();
            while ((c = reader.read()) != -1) {
                sb.append((char)c);
            }
            s = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return s;
    }

    public static String slurpFile(String fileName) {
        File f = new File(fileName);
        return Util.slurpFile(f);
    }

    public static String slurpFile(File f) {
        String s;
        try {
            int c;
            FileReader fr = new FileReader(f);
            StringBuilder sb = new StringBuilder();
            while ((c = fr.read()) != -1) {
                sb.append((char)c);
            }
            s = sb.toString();
        }
        catch (Exception e) {
            s = null;
            e.printStackTrace();
        }
        return s;
    }

    public static Vector<String> tokenize(String s) {
        Vector<String> v = new Vector<String>();
        Scanner scan = new Scanner(s);
        while (scan.hasNext()) {
            v.add(scan.next());
        }
        return v;
    }

    public static String englishList(List<String> list) {
        int n = list.size();
        if (n == 0) {
            return "";
        }
        if (n == 1) {
            return list.get(0);
        }
        if (n == 2) {
            return String.valueOf(list.get(0)) + " and " + list.get(1);
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < n - 1) {
            s.append(list.get(i));
            s.append(", ");
            ++i;
        }
        s.append("and ");
        s.append(list.get(n - 1));
        return s.toString();
    }

    public static String capitalizeFirst(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len < 2) {
            return s.toUpperCase();
        }
        return String.valueOf(s.substring(0).toUpperCase()) + s.substring(1, len);
    }

    public static Vector<String> getSubBlocks(String text) {
        Vector<String> result = new Vector<String>();
        int braces = 0;
        int n = text.length();
        boolean output = false;
        StringBuilder block = new StringBuilder();
        int i = 0;
        while (i < n) {
            char c = text.charAt(i);
            if (output) {
                block.append(c);
            }
            if (c == '{') {
                if (++braces == 1) {
                    output = true;
                    block = new StringBuilder();
                }
            } else if (c == '}' && --braces == 0) {
                output = false;
                block.deleteCharAt(block.length() - 1);
                result.add(block.toString());
            }
            ++i;
        }
        return result;
    }

    public static byte[] graphToPNG(String graphDOT) {
        byte[] img = null;
        try {
            Process dot = Runtime.getRuntime().exec("dot -Tpng");
            OutputStreamWriter pout = new OutputStreamWriter(dot.getOutputStream());
            InputStream pin = dot.getInputStream();
            pout.write(graphDOT);
            pout.close();
            img = Util.streamToByteArray(pin);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return img;
    }

    public static String graphToPS(String graphDOT) {
        String ps = null;
        try {
            int c;
            Process dot = Runtime.getRuntime().exec("dot -Tps");
            OutputStreamWriter pout = new OutputStreamWriter(dot.getOutputStream());
            InputStream pin = dot.getInputStream();
            pout.write(graphDOT);
            pout.close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(pin));
            StringBuilder sb = new StringBuilder();
            while ((c = reader.read()) != -1) {
                sb.append((char)c);
            }
            ps = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ps;
    }

    public static void saveString(String s, String fileName) {
        try {
            FileWriter out = new FileWriter(fileName);
            out.write(s);
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String stripHTML(String htmlText) {
        String result = htmlText;
        result = result.replaceAll("\n", " ");
        result = result.replaceAll("<br>", "\n");
        result = result.replaceAll("</p>", "\n");
        result = result.replaceAll("<(.+)?>", "");
        result = result.trim();
        return result;
    }

    public static String renderNumberedList(List<String> items) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String s : items) {
            sb.append(String.valueOf(++i) + ") " + s + "\n");
        }
        return sb.toString();
    }
}

