/*
 * Decompiled with CFR 0.152.
 */
package ilist.model;

import ilist.model.OperationSequence;
import ilist.model.StateSpace;
import ilist.problem.Problem;
import ilist.problem.Scenario;
import ilist.statement.Statement;
import java.io.Serializable;
import java.util.Vector;

public class LinkedListModel
implements Serializable {
    private Vector<StateSpace> stateSpaces = new Vector();
    private OperationSequence operationSequence;
    private Problem problem;
    private boolean isFinal = false;

    public LinkedListModel() {
        this.stateSpaces.add(new StateSpace());
        this.operationSequence = new OperationSequence();
        this.problem = Problem.EMPTY;
    }

    public LinkedListModel(int iNumStateSpaces) {
        int i = 0;
        while (i < iNumStateSpaces) {
            this.stateSpaces.add(new StateSpace());
            ++i;
        }
        this.operationSequence = new OperationSequence();
        this.problem = Problem.EMPTY;
    }

    public LinkedListModel(Problem p) {
        this.operationSequence = new OperationSequence();
        this.problem = p;
        Vector<String> notTemporaryVariables = new Vector<String>();
        notTemporaryVariables.addAll(p.getIdealSolution().getImportantHeads());
        notTemporaryVariables.addAll(p.getIdealSolution().getImportantPointers());
        for (Scenario s : this.problem.getScenarios()) {
            StateSpace ss = new StateSpace();
            s.getInitSequence().execute(ss);
            Vector<String> initialVariables = ss.variableList();
            for (String v : notTemporaryVariables) {
                if (initialVariables.contains(v)) continue;
                initialVariables.add(v);
            }
            ss = new StateSpace(initialVariables);
            s.getInitSequence().execute(ss);
            this.stateSpaces.add(ss);
        }
    }

    public LinkedListModel(LinkedListModel model) {
        for (StateSpace s : model.stateSpaces) {
            this.stateSpaces.add(new StateSpace(s));
        }
        this.operationSequence = new OperationSequence(model.operationSequence);
        this.problem = model.problem;
    }

    public Problem getProblem() {
        return this.problem;
    }

    public OperationSequence getOperationSequence() {
        return this.operationSequence;
    }

    public String execute(Statement st, int iStateSpaceId) {
        StringBuilder err = new StringBuilder();
        int nScenarios = this.stateSpaces.size();
        int i = 0;
        while (i < nScenarios) {
            StateSpace space;
            String scenarioError;
            if ((iStateSpaceId == -1 || i == iStateSpaceId) && (scenarioError = st.execute(space = this.stateSpaces.elementAt(i))) != null) {
                if (nScenarios == 1) {
                    err.append(String.valueOf(scenarioError) + "\n");
                } else {
                    err.append("In scenario #" + (i + 1) + ", " + scenarioError + "\n\n");
                }
            }
            ++i;
        }
        if (err.length() > 0) {
            return "You want to execute:\n" + st + "\nI'm sorry, I can't do that.\n\n" + err;
        }
        return null;
    }

    public Vector<StateSpace> getStateSpaces() {
        return this.stateSpaces;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isFinal() {
        return this.isFinal;
    }
}

