/*
 * Decompiled with CFR 0.152.
 */
package ilist.model;

import ilist.model.LinkedListModel;
import ilist.problem.Problem;
import ilist.statement.Statement;
import java.util.Stack;

public class MultiModel {
    private LinkedListModel currentModel = new LinkedListModel();
    private Stack<LinkedListModel> modelUndoStack = new Stack();
    private Stack<LinkedListModel> modelRedoStack = new Stack();

    public LinkedListModel getCurrentModel() {
        return this.currentModel;
    }

    public Problem getProblem() {
        return this.currentModel.getProblem();
    }

    public void setProblem(Problem p) {
        this.currentModel = new LinkedListModel(p);
        this.modelUndoStack.clear();
        this.modelRedoStack.clear();
    }

    public void Reset() {
        this.Reset(1);
    }

    public void Reset(int iStateSpaces) {
        this.currentModel = new LinkedListModel(iStateSpaces);
        this.modelUndoStack = new Stack();
        this.modelRedoStack = new Stack();
    }

    public String execute(Statement st, boolean bRecord) {
        return this.execute(st, bRecord, -1);
    }

    public String execute(Statement st, boolean bRecord, int iStateSpaceId) {
        if (st == null) {
            return null;
        }
        LinkedListModel modelClone = new LinkedListModel(this.currentModel);
        String error = modelClone.execute(st, iStateSpaceId);
        if (error != null) {
            return error;
        }
        if (bRecord) {
            this.modelUndoStack.push(this.currentModel);
        }
        this.currentModel = modelClone;
        st.SetTag(bRecord ? -1 : 0);
        this.currentModel.getOperationSequence().add(st);
        this.modelRedoStack.clear();
        return null;
    }

    public void undo() {
        if (!this.modelUndoStack.isEmpty()) {
            this.modelRedoStack.push(this.currentModel);
            this.currentModel = this.modelUndoStack.pop();
        }
    }

    public void redo() {
        if (!this.modelRedoStack.isEmpty()) {
            this.modelUndoStack.push(this.currentModel);
            this.currentModel = this.modelRedoStack.pop();
        }
    }

    public boolean isUndoStackEmpty() {
        return this.modelUndoStack.isEmpty();
    }

    public boolean isRedoStackEmpty() {
        return this.modelRedoStack.isEmpty();
    }
}

