/*
 * Decompiled with CFR 0.152.
 */
package ilist.model;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.parser.IListParser;
import ilist.model.StateSpace;
import ilist.statement.Block;
import ilist.statement.Statement;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OperationSequence
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<Statement> sequence;
    private static Pattern pCode = Pattern.compile("(?is)<code>(.*?)</code>");

    public OperationSequence() {
        this.sequence = new Vector();
    }

    public OperationSequence(OperationSequence otherSequence) {
        this.sequence = new Vector<Statement>(otherSequence.sequence);
    }

    public OperationSequence(String codeXML) {
        this();
        Block code;
        Matcher m1 = pCode.matcher(codeXML);
        if (m1.find() && (code = IListParser.parse(m1.group(1))) != null) {
            this.add(code);
        }
    }

    public void execute(StateSpace s) {
        for (Statement t : this.sequence) {
            t.execute(s);
        }
    }

    public void add(Statement s) {
        this.sequence.add(s);
    }

    public void clear() {
        this.sequence.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Statement s : this.sequence) {
            sb.append("<statement>" + s + "</statement>\n");
        }
        return sb.toString();
    }

    public Vector<Statement> getStatements() {
        return this.sequence;
    }

    public int size() {
        return this.sequence.size();
    }
}

