/*
 * Decompiled with CFR 0.152.
 */
package ilist.model;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FRelation;
import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.feedback.FRelationSet;
import ilist.model.GListEquivalenceComparator;
import ilist.model.GNode;
import ilist.model.VariableMapping;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Vector;
import org.jgrapht.DirectedGraph;
import org.jgrapht.experimental.equivalence.EquivalenceComparator;
import org.jgrapht.experimental.isomorphism.AdaptiveIsomorphismInspectorFactory;
import org.jgrapht.experimental.isomorphism.GraphIsomorphismInspector;
import org.jgrapht.experimental.isomorphism.IsomorphismRelation;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;

public class StateSpace
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static GNode nDeletedNodes = new GNode(1, "deleted", "*");
    public static GNode nNull = new GNode(1, "null", "/");
    public static GNode nGarbage = new GNode(1, "garbage", "#");
    public static GNode nUndefined = new GNode(1, "undefined", "?");
    private DefaultDirectedGraph<GNode, DefaultEdge> graph;
    private int nodeSequence = 0;
    private Vector<GNode> variables;
    private Vector<GNode> nodes;
    private Vector<GNode> deletedNodes;
    private Vector<String> notTemporary;
    private static GListEquivalenceComparator eqComparator = new GListEquivalenceComparator();

    public StateSpace() {
        this.variables = new Vector();
        this.nodes = new Vector();
        this.deletedNodes = new Vector();
        this.notTemporary = new Vector();
        this.graph = new DefaultDirectedGraph(DefaultEdge.class);
        this.graph.addVertex((Object)nDeletedNodes);
        this.graph.addVertex((Object)nNull);
        this.graph.addVertex((Object)nGarbage);
        this.graph.addVertex((Object)nUndefined);
    }

    public StateSpace(Vector<String> notTemporaryVariables) {
        this();
        this.notTemporary.addAll(notTemporaryVariables);
    }

    public StateSpace(StateSpace space) {
        this.nodeSequence = space.nodeSequence;
        this.variables = new Vector<GNode>(space.variables);
        this.nodes = new Vector<GNode>(space.nodes);
        this.deletedNodes = new Vector<GNode>(space.deletedNodes);
        this.notTemporary = new Vector<String>(space.notTemporary);
        this.graph = (DefaultDirectedGraph)space.graph.clone();
    }

    public StateSpace(StateSpace space, VariableMapping mapping) {
        this(space);
        if (mapping == null) {
            return;
        }
        Vector<GNode> replacementVariables = new Vector<GNode>();
        Vector<GNode> targetNodes = new Vector<GNode>();
        int nv = this.variables.size();
        int i = 0;
        while (i < nv) {
            String sv2;
            GNode v1 = this.variables.elementAt(i);
            String sv1 = v1.getLabel();
            if (!sv1.equals(sv2 = mapping.mappingOf(sv1))) {
                GNode v2 = new GNode(v1.getType(), sv2, sv2);
                replacementVariables.add(v2);
                targetNodes.add(this.findNext(v1));
                this.graph.removeVertex((Object)v1);
                this.variables.set(i, v2);
                int ntIndex = this.notTemporary.indexOf(sv1);
                if (ntIndex >= 0) {
                    this.notTemporary.set(ntIndex, sv2);
                }
            }
            ++i;
        }
        int n = replacementVariables.size();
        int i2 = 0;
        while (i2 < n) {
            GNode v = (GNode)replacementVariables.elementAt(i2);
            GNode t = (GNode)targetNodes.elementAt(i2);
            this.graph.addVertex((Object)v);
            this.graph.addEdge((Object)v, (Object)t);
            ++i2;
        }
    }

    public GNode addVariable(String v) {
        GNode y = null;
        if (this.findVariable(v) == null) {
            y = this.notTemporary.contains(v) ? new GNode(2, v, v) : new GNode(3, v, v);
            this.graph.addVertex((Object)y);
            this.graph.addEdge((Object)y, (Object)nUndefined);
            this.variables.add(y);
        }
        return y;
    }

    public boolean removeVariable(String v) {
        GNode nv = this.findVariable(v);
        if (nv == null) {
            return false;
        }
        this.graph.removeVertex((Object)nv);
        this.variables.remove(nv);
        return true;
    }

    public GNode createNode(String label) {
        ++this.nodeSequence;
        GNode nn = new GNode(4, "n" + this.nodeSequence, label);
        this.graph.addVertex((Object)nn);
        this.graph.addEdge((Object)nn, (Object)nUndefined);
        this.nodes.add(nn);
        return nn;
    }

    public GNode updateNodeLabel(GNode x, String newLabel) {
        if (x == null) {
            return null;
        }
        int ix = this.nodes.indexOf(x);
        if (ix < 0) {
            return null;
        }
        String id = x.getId();
        boolean selfLinked = false;
        Vector<GNode> sources = new Vector<GNode>();
        for (DefaultEdge e : this.graph.incomingEdgesOf((Object)x)) {
            GNode gNode = (GNode)this.graph.getEdgeSource((Object)e);
            if (gNode != x) {
                sources.add(gNode);
                continue;
            }
            selfLinked = true;
        }
        Vector<GNode> targets = new Vector<GNode>();
        for (DefaultEdge e : this.graph.outgoingEdgesOf((Object)x)) {
            GNode t = (GNode)this.graph.getEdgeTarget((Object)e);
            if (t == x) continue;
            targets.add(t);
        }
        this.graph.removeVertex((Object)x);
        GNode y = new GNode(4, id, newLabel);
        this.graph.addVertex((Object)y);
        for (GNode gNode : sources) {
            this.graph.addEdge((Object)gNode, (Object)y);
        }
        for (GNode gNode : targets) {
            this.graph.addEdge((Object)y, (Object)gNode);
        }
        if (selfLinked) {
            this.graph.addEdge((Object)y, (Object)y);
        }
        this.nodes.set(ix, y);
        return y;
    }

    public boolean deleteNode(GNode x) {
        if (x.getType() != 4) {
            return false;
        }
        for (DefaultEdge inEdge : this.graph.incomingEdgesOf((Object)x)) {
            GNode source = (GNode)this.graph.getEdgeSource((Object)inEdge);
            if (source.getType() == 1) continue;
            this.graph.addEdge((Object)source, (Object)nGarbage);
        }
        this.graph.removeVertex((Object)x);
        this.graph.addVertex((Object)x);
        this.graph.addEdge((Object)nDeletedNodes, (Object)x);
        this.nodes.remove(x);
        this.deletedNodes.add(x);
        return true;
    }

    public void link(GNode x, GNode y) {
        if (x.getType() != 1) {
            this.graph.removeAllEdges(new ArrayList(this.graph.outgoingEdgesOf((Object)x)));
        }
        this.graph.addEdge((Object)x, (Object)y);
    }

    public GNode findVariable(String name) {
        for (GNode n : this.variables) {
            if (!n.getLabel().equals(name)) continue;
            return n;
        }
        return null;
    }

    public GNode findNext(GNode x) {
        GNode y = null;
        if (x != null) {
            for (DefaultEdge e : this.graph.outgoingEdgesOf((Object)x)) {
                y = (GNode)this.graph.getEdgeTarget((Object)e);
            }
        }
        return y;
    }

    public String partialDOT() {
        StringBuilder sb = new StringBuilder();
        sb.append("  rankdir=LR;\n");
        sb.append("  {rank=min;\n");
        sb.append("  n" + nDeletedNodes.getId() + " [fixedsize=true,fontsize=40,label=\"" + nDeletedNodes.getLabel() + "\",shape=hexagon];\n");
        for (GNode v : this.variables) {
            sb.append("  n" + v.getId() + " [fixedsize=true,fontsize=40,label=\"" + v.getLabel() + "\"];\n");
        }
        sb.append("  }\n");
        for (GNode v : this.nodes) {
            sb.append("  n" + v.getId() + " [fixedsize=true,fontsize=40,label=\"" + v.getLabel() + "\",shape=box];\n");
        }
        for (GNode v : this.deletedNodes) {
            sb.append("  n" + v.getId() + " [fixedsize=true,fontsize=40,label=\"" + v.getLabel() + "\",shape=box];\n");
        }
        sb.append("  {rank=max;\n");
        sb.append("  n" + nGarbage.getId() + " [fixedsize=true,fontsize=40,label=\"" + nGarbage.getLabel() + "\",shape=hexagon];\n");
        sb.append("  n" + nUndefined.getId() + " [fixedsize=true,fontsize=40,label=\"" + nUndefined.getLabel() + "\",shape=hexagon];\n");
        sb.append("  n" + nNull.getId() + " [fixedsize=true,fontsize=40,label=\"" + nNull.getLabel() + "\",shape=hexagon];\n");
        sb.append("  }\n");
        for (DefaultEdge e : this.graph.edgeSet()) {
            sb.append("  n" + ((GNode)this.graph.getEdgeSource((Object)e)).getId() + " -> n" + ((GNode)this.graph.getEdgeTarget((Object)e)).getId() + ";\n");
        }
        return sb.toString();
    }

    public DirectedGraph<GNode, DefaultEdge> getGraph() {
        return this.graph;
    }

    public Vector<GNode> getVariables() {
        return this.variables;
    }

    public Vector<GNode> getNodes() {
        return this.nodes;
    }

    public Vector<GNode> getDeletedNodes() {
        return this.deletedNodes;
    }

    public boolean isIsomorphic(StateSpace otherSpace) {
        return AdaptiveIsomorphismInspectorFactory.createIsomorphismInspectorByType((int)0, this.graph, otherSpace.graph, (EquivalenceComparator)eqComparator, null).isIsomorphic();
    }

    public Vector<VariableMapping> variableMappings(StateSpace otherSpace) {
        GraphIsomorphismInspector iso = AdaptiveIsomorphismInspectorFactory.createIsomorphismInspectorByType((int)0, this.graph, otherSpace.graph, (EquivalenceComparator)eqComparator, null);
        if (!iso.isIsomorphic()) {
            return null;
        }
        Vector<VariableMapping> v = new Vector<VariableMapping>();
        while (iso.hasNext()) {
            IsomorphismRelation x = (IsomorphismRelation)iso.next();
            VariableMapping map = new VariableMapping();
            for (GNode var : this.variables) {
                map.mapVariables(var.getLabel(), ((GNode)x.getVertexCorrespondence((Object)var, true)).getLabel());
            }
            if (map.isEmpty()) continue;
            v.add(map);
        }
        return v;
    }

    public Vector<String> variableList() {
        Vector<String> result = new Vector<String>();
        for (GNode v : this.variables) {
            result.add(v.getLabel());
        }
        return result;
    }

    public Vector<String> notTemporaryVariableList() {
        return new Vector<String>(this.notTemporary);
    }

    public FRelationSet fRelations() {
        GNode next;
        FRelationSet result = new FRelationSet();
        for (GNode v : this.variables) {
            result.add(new FRelation(FRelation.EXISTS, v.getId(), null));
            result.add(new FRelation(FRelation.ENTITY_TYPE, v.getId(), FRelation.TYPE_VARIABLE));
            next = this.findNext(v);
            if (next == null) continue;
            result.add(new FRelation(FRelation.POINTS_TO, v.getId(), next.getId()));
        }
        for (GNode n : this.nodes) {
            result.add(new FRelation(FRelation.EXISTS, n.getId(), null));
            result.add(new FRelation(FRelation.ENTITY_TYPE, n.getId(), FRelation.TYPE_NODE));
            result.add(new FRelation(FRelation.CONTENT, n.getId(), n.getLabel()));
            next = this.findNext(n);
            if (next == null) continue;
            result.add(new FRelation(FRelation.POINTS_TO, n.getId(), next.getId()));
        }
        result.add(new FRelation(FRelation.ENTITY_TYPE, "null", FRelation.TYPE_SPECIAL));
        result.add(new FRelation(FRelation.ENTITY_TYPE, "garbage", FRelation.TYPE_SPECIAL));
        result.add(new FRelation(FRelation.ENTITY_TYPE, "undefined", FRelation.TYPE_SPECIAL));
        return result;
    }
}

