/*
 * Decompiled with CFR 0.152.
 */
package ilist.model;

import ilist.model.VariableNameGenerator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class VariableMapping
implements Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<String, String> map = new HashMap();
    private static String[] friendlyNames = new String[]{"T", "Q", "X", "Y", "Z", "W", "A", "B", "C", "D", "E", "F", "G", "H", "M", "N", "V", "P"};

    public void mapVariables(String v1, String v2) {
        this.map.put(v1, v2);
    }

    public String mappingOf(String v) {
        String result = this.map.get(v);
        return result;
    }

    public static VariableMapping integrateWithIdentity(VariableMapping mapping, Vector<String> variableList) {
        VariableMapping result = new VariableMapping();
        for (String variable : variableList) {
            if (mapping != null) {
                String target = mapping.map.get(variable);
                if (target != null) {
                    result.map.put(variable, target);
                    continue;
                }
                result.map.put(variable, variable);
                continue;
            }
            result.map.put(variable, variable);
        }
        return result;
    }

    public static VariableMapping integrateWithNewNames(VariableMapping mapping, Vector<String> variableList, Vector<String> notTemporaryVariableList, VariableNameGenerator nameGenerator) {
        VariableMapping result = new VariableMapping();
        for (String variable : variableList) {
            if (mapping != null) {
                String target = mapping.map.get(variable);
                if (target != null) {
                    result.map.put(variable, target);
                    continue;
                }
                if (notTemporaryVariableList.contains(variable)) {
                    result.map.put(variable, variable);
                    continue;
                }
                result.map.put(variable, nameGenerator.getNextName());
                continue;
            }
            if (notTemporaryVariableList.contains(variable)) {
                result.map.put(variable, variable);
                continue;
            }
            result.map.put(variable, nameGenerator.getNextName());
        }
        return result;
    }

    public boolean isCompatible(VariableMapping otherMapping) {
        if (otherMapping == null || otherMapping.isEmpty()) {
            return true;
        }
        for (String v : this.map.keySet()) {
            String x = this.map.get(v);
            String y = otherMapping.map.get(v);
            if (y == null || x.equals(y)) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public VariableMapping inverseMapping() {
        VariableMapping inverse = new VariableMapping();
        for (String key : this.map.keySet()) {
            inverse.map.put(this.map.get(key), key);
        }
        return inverse;
    }

    public void changeUnfriendlyValues() {
        HashSet<String> names = new HashSet<String>();
        names.addAll(this.map.values());
        for (String name : names) {
            if (!name.startsWith(VariableNameGenerator.PREFIX)) continue;
            String replacement = this.chooseFriendlyNameToReplace(name);
            this.replaceValues(name, replacement);
        }
    }

    private String chooseFriendlyNameToReplace(String nameToBeReplaced) {
        String result = null;
        String[] stringArray = friendlyNames;
        int n = friendlyNames.length;
        int n2 = 0;
        while (n2 < n) {
            String candidate = stringArray[n2];
            if (!this.map.keySet().contains(candidate) && !this.map.values().contains(candidate)) {
                result = candidate;
                break;
            }
            ++n2;
        }
        int i = 2;
        while (result == null) {
            String candidate = "T" + i;
            if (!this.map.keySet().contains(candidate) && !this.map.values().contains(candidate)) {
                result = candidate;
            }
            ++i;
        }
        return result;
    }

    private void replaceValues(String oldName, String newName) {
        ArrayList<String> keys = new ArrayList<String>(this.map.keySet());
        for (String key : keys) {
            String value = this.map.get(key);
            if (!oldName.equals(value)) continue;
            this.map.put(key, newName);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{ ");
        for (String v1 : this.map.keySet()) {
            sb.append(String.valueOf(v1) + "->" + this.map.get(v1) + " ");
        }
        sb.append("}");
        return sb.toString();
    }
}

