/*
 * Decompiled with CFR 0.152.
 */
package ilist.problem;

import ilist.problem.Scenario;
import ilist.problem.Solution;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Problem
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static Problem EMPTY = new Problem();
    public Random m_Rand = new Random(System.currentTimeMillis());
    private String id;
    private String text;
    private Vector<Scenario> scenarios;
    private Solution idealSolution;
    private String commandInterface = "line";
    private ArrayList<String> m_WoePaths = null;
    private static Pattern pWoe = Pattern.compile("(?is)<woe>(.*?)</woe>");
    private static Pattern pNumber = Pattern.compile("(?is)<number>(.*?)</number>");
    private static Pattern pText = Pattern.compile("(?is)<text>(.*?)</text>");
    private static Pattern pScenario = Pattern.compile("(?is)<scenario>(.*?)</scenario>");
    private static Pattern pSolution = Pattern.compile("(?is)<solution>(.*?)</solution>");
    private static Pattern pCommands = Pattern.compile("(?is)<commands>(.*?)</commands>");

    private Problem() {
        this.id = "0";
        this.text = "Welcome to the world of Linked Lists! You can practice with the interface, or select a problem from the \"Problems\" menu.";
        this.scenarios = new Vector();
        this.idealSolution = new Solution();
    }

    public Problem(String problemXML) {
        this.scenarios = new Vector();
        this.m_WoePaths = new ArrayList();
        Matcher m = pNumber.matcher(problemXML);
        if (m.find()) {
            this.id = m.group(1);
        }
        if ((m = pText.matcher(problemXML)).find()) {
            this.text = m.group(1);
        }
        m = pScenario.matcher(problemXML);
        while (m.find()) {
            Scenario scenario = new Scenario(m.group(1));
            this.scenarios.add(scenario);
        }
        m = pSolution.matcher(problemXML);
        if (m.find()) {
            this.idealSolution = new Solution(m.group(1), this.scenarios);
        }
        if ((m = pCommands.matcher(problemXML)).find()) {
            this.commandInterface = m.group(1);
        }
        m = pWoe.matcher(problemXML);
        while (m.find()) {
            String woePath = m.group(1);
            this.m_WoePaths.add(woePath);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public Solution getIdealSolution() {
        return this.idealSolution;
    }

    public Vector<Scenario> getScenarios() {
        return this.scenarios;
    }

    public String getCommandInterface() {
        return this.commandInterface;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<problem>\n<number>" + this.id + "</number>\n<description>\n<text>" + this.text + "</text>\n");
        for (Scenario s : this.scenarios) {
            sb.append("<scenario>" + s + "</scenario>\n");
        }
        sb.append("</description>\n</problem>");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Problem other = (Problem)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String GetWoePath() {
        if (this.m_WoePaths != null) {
            if (this.m_WoePaths.size() == 0) {
                return "";
            }
            if (this.m_WoePaths.size() == 1) {
                return this.m_WoePaths.get(0);
            }
            return this.m_WoePaths.get(this.m_Rand.nextInt(this.m_WoePaths.size()));
        }
        return "";
    }
}

