/*
 * Decompiled with CFR 0.152.
 */
package ilist.problem;

import ilist.misc.Util;
import ilist.problem.Problem;
import java.io.Serializable;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ProblemSet
implements Iterable<Problem>,
Serializable {
    private TreeMap<String, Problem> problems = new TreeMap();
    private static ProblemSet instance;

    public static ProblemSet getInstance() {
        if (instance == null) {
            instance = new ProblemSet(Util.slurpFile(ProblemSet.class.getResource("problems.xml")));
        }
        return instance;
    }

    private ProblemSet(String xmlProblems) {
        Pattern pProblem = Pattern.compile("(?is)<problem>(.*?)</problem>");
        Matcher m = pProblem.matcher(xmlProblems);
        while (m.find()) {
            Problem p = new Problem(m.group(1));
            this.problems.put(p.getId(), p);
        }
    }

    public Problem get(String id) {
        return this.problems.get(id);
    }

    @Override
    public Iterator<Problem> iterator() {
        return this.problems.values().iterator();
    }
}

