/*
 * Decompiled with CFR 0.152.
 */
package ilist.problem;

import ilist.model.OperationSequence;
import ilist.statement.SimpleParser;
import ilist.statement.Statement;
import java.awt.Point;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Scenario
implements Serializable {
    private static final long serialVersionUID = 1L;
    private OperationSequence initSequence = new OperationSequence();
    private Vector<Point> initLocations = new Vector();
    private Vector<String> initIds = new Vector();
    private static Pattern pStatement = Pattern.compile("(?is)<statement>(.*?)</statement>");
    private static Pattern pNodeId = Pattern.compile("(?is)<id>(.*?)</id>");
    private static Pattern pCoord = Pattern.compile("(?is)<coord>(.*?),(.*?)</coord>");

    public Scenario(String scenarioXML) {
        SimpleParser statementParser = new SimpleParser();
        Matcher m = pStatement.matcher(scenarioXML);
        while (m.find()) {
            String sStatement = m.group(1);
            Statement stm = statementParser.parse(sStatement);
            this.initSequence.add(stm);
        }
        m = pNodeId.matcher(scenarioXML);
        while (m.find()) {
            String nodeId = m.group(1);
            this.initIds.add(nodeId);
        }
        m = pCoord.matcher(scenarioXML);
        while (m.find()) {
            Point p = new Point(Integer.parseInt(m.group(1)), Integer.parseInt(m.group(2)));
            this.initLocations.add(p);
        }
    }

    public Vector<String> getInitIds() {
        return this.initIds;
    }

    public Map<String, Point> getInitLocations() {
        HashMap<String, Point> m = new HashMap<String, Point>();
        int n = Math.min(this.initIds.size(), this.initLocations.size());
        int i = 0;
        while (i < n) {
            m.put(this.initIds.elementAt(i), this.initLocations.elementAt(i));
            ++i;
        }
        return m;
    }

    public OperationSequence getInitSequence() {
        return this.initSequence;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.initSequence);
        for (String n : this.initIds) {
            sb.append("<id>" + n + "</id>\n");
        }
        for (Point p : this.initLocations) {
            sb.append("<coord>" + (int)p.getX() + "," + (int)p.getY() + "</coord>\n");
        }
        return sb.toString();
    }
}

