/*
 * Decompiled with CFR 0.152.
 */
package ilist.problem;

import ilist.model.OperationSequence;
import ilist.model.StateSpace;
import ilist.problem.Scenario;
import java.io.Serializable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Solution
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Vector<StateSpace> stateSpaces = new Vector();
    private OperationSequence operationSequence;
    private Vector<String> importantHeads;
    private Vector<String> importantPointers;
    private static Pattern pListHead = Pattern.compile("(?is)<listhead>(.*?)</listhead>");
    private static Pattern pPointer = Pattern.compile("(?is)<pointer>(.*?)</pointer>");

    public Solution() {
        this.operationSequence = new OperationSequence();
        this.importantHeads = new Vector();
        this.importantPointers = new Vector();
    }

    public Solution(String solutionXML, Vector<Scenario> scenarios) {
        this.operationSequence = new OperationSequence(solutionXML);
        this.importantHeads = new Vector();
        this.importantPointers = new Vector();
        for (Scenario scenario : scenarios) {
            StateSpace s = new StateSpace();
            scenario.getInitSequence().execute(s);
            this.operationSequence.execute(s);
            this.stateSpaces.add(s);
        }
        Matcher m1 = pListHead.matcher(solutionXML);
        while (m1.find()) {
            this.importantHeads.add(m1.group(1));
        }
        m1 = pPointer.matcher(solutionXML);
        while (m1.find()) {
            this.importantPointers.add(m1.group(1));
        }
    }

    public Vector<StateSpace> getStateSpaces() {
        return this.stateSpaces;
    }

    public OperationSequence getOperationSequence() {
        return this.operationSequence;
    }

    public Vector<String> getImportantHeads() {
        return this.importantHeads;
    }

    public Vector<String> getImportantPointers() {
        return this.importantPointers;
    }
}

