/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;
import java.util.Collection;
import java.util.Vector;

public class Block
extends Statement {
    private static final long serialVersionUID = 1L;
    private Vector<Statement> body = new Vector();

    public Block() {
    }

    public Block(Collection<Statement> statements) {
        this.body.addAll(statements);
    }

    public void addToBody(Statement st) {
        this.body.add(st);
    }

    @Override
    public String execute(StateSpace s) {
        for (Statement st : this.body) {
            String stError = st.execute(s);
            if (stError == null) continue;
            return "I tried to execute\n" + st + "\nbut " + stError;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Statement st : this.body) {
            sb.append(String.valueOf(st.toString()) + "\n");
        }
        int len = sb.length();
        if (len > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    public int size() {
        return this.body.size();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Block other = (Block)obj;
        return !(this.body == null ? other.body != null : !this.body.equals(other.body));
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        Block clone = new Block();
        for (Statement s : this.body) {
            clone.body.add(s.morphedClone(mapping));
        }
        return clone;
    }
}

