/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.statement.Comparison;
import ilist.statement.DataEqConst;
import ilist.statement.NextEqNext;
import ilist.statement.NextEqNull;
import ilist.statement.NextEqVar;
import ilist.statement.VarEqNull;
import ilist.statement.VarEqVar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComparisonParser {
    private Pattern p1 = Pattern.compile("(?i)([a-zA-Z_]\\w*)(?:\\.|->)(?:data|info)(==|!=)(?:\"(.*)\"|(\\d+));?");
    private Pattern p2 = Pattern.compile("(?i)([a-zA-Z_]\\w*)(?:(?:\\.|->)(next|link))?(==|!=)(?:null);?");
    private Pattern p3 = Pattern.compile("(?i)([a-zA-Z_]\\w*)(?:(?:\\.|->)(next|link))?(==|!=)([a-zA-Z_]\\w*)(?:(?:\\.|->)(next|link))?;?");

    public Comparison parse(String s) {
        Matcher m = this.p1.matcher(s = s.replaceAll("\\s", ""));
        if (m.matches()) {
            String variable = m.group(1).toUpperCase();
            boolean notEqual = m.group(2).equals("!=");
            String dataField = m.group(3) != null ? m.group(3).toUpperCase() : m.group(4).toUpperCase();
            return new DataEqConst(variable, dataField, notEqual);
        }
        m = this.p2.matcher(s);
        if (m.matches()) {
            boolean notEqual;
            String variable = m.group(1).toUpperCase();
            boolean nextField = m.group(2) != null;
            boolean bl = notEqual = m.group(3).equals("!=");
            if (!nextField) {
                return new VarEqNull(variable, notEqual);
            }
            return new NextEqNull(variable, notEqual);
        }
        m = this.p3.matcher(s);
        if (m.matches()) {
            boolean nextField2;
            String var1 = m.group(1).toUpperCase();
            boolean nextField1 = m.group(2) != null;
            boolean notEqual = m.group(3).equals("!=");
            String var2 = m.group(4).toUpperCase();
            boolean bl = nextField2 = m.group(5) != null;
            if (!nextField1 && !nextField2) {
                return new VarEqVar(var1, var2, notEqual);
            }
            if (nextField1 && !nextField2) {
                return new NextEqVar(var1, var2, notEqual);
            }
            if (!nextField1 && nextField2) {
                return new NextEqVar(var2, var1, notEqual);
            }
            return new NextEqNext(var1, var2, notEqual);
        }
        return null;
    }
}

