/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;

public class ConstToData
extends Statement {
    private static final long serialVersionUID = 1L;

    public ConstToData(String leftTerm, String rightTerm) {
        this.leftTerm = leftTerm;
        this.rightTerm = rightTerm;
    }

    @Override
    public String execute(StateSpace s) {
        GNode nv = s.findVariable(this.leftTerm);
        if (nv == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        GNode ndest = s.findNext(nv);
        if (ndest == null || ndest.getType() != 4) {
            return "I can't find the node pointed to by " + this.leftTerm + ".";
        }
        s.updateNodeLabel(ndest, this.rightTerm);
        return null;
    }

    public String toString() {
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + ".data = " + this.rightTerm + ";";
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + "->data = " + this.rightTerm + ";";
        }
        return "";
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        String left = mapping.mappingOf(this.leftTerm);
        String right = this.rightTerm;
        ConstToData clone = new ConstToData(left, right);
        return clone;
    }
}

