/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;

public class DataToData
extends Statement {
    private static final long serialVersionUID = 1L;

    public DataToData(String leftTerm, String rightTerm) {
        this.leftTerm = leftTerm;
        this.rightTerm = rightTerm;
    }

    @Override
    public String execute(StateSpace s) {
        GNode nv1 = s.findVariable(this.leftTerm);
        GNode nv2 = s.findVariable(this.rightTerm);
        if (nv1 == null && nv2 == null && !this.leftTerm.equals(this.rightTerm)) {
            return "Variables " + this.leftTerm + " and " + this.rightTerm + " do not exist.";
        }
        if (nv1 == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        if (nv2 == null) {
            return "Variable " + this.rightTerm + " does not exist.";
        }
        GNode n1 = s.findNext(nv1);
        GNode n2 = s.findNext(nv2);
        if (!this.leftTerm.equals(this.rightTerm) && (n1 == null && n2 == null || n1.getType() != 4 && n2.getType() != 4)) {
            return "I can't find neither the node pointed to by " + this.leftTerm + "nor the node pointed to by " + this.rightTerm + ".";
        }
        if (n1 == null || n1.getType() != 4) {
            return "I can't find the node pointed to by " + this.leftTerm + ".";
        }
        if (n2 == null || n2.getType() != 4) {
            return "I can't find the node pointed to by " + this.rightTerm + ".";
        }
        String dataField = n2.getLabel();
        s.updateNodeLabel(n1, dataField);
        return null;
    }

    public String toString() {
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + ".data = " + this.rightTerm + ".data;";
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + "->data = " + this.rightTerm + "->data;";
        }
        return "";
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        String left = mapping.mappingOf(this.leftTerm);
        String right = mapping.mappingOf(this.rightTerm);
        DataToData clone = new DataToData(left, right);
        return clone;
    }
}

