/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;

public class DeleteNode
extends Statement {
    private static final long serialVersionUID = 1L;

    public DeleteNode(String leftTerm) {
        this.leftTerm = leftTerm;
    }

    @Override
    public String execute(StateSpace s) {
        GNode nv = s.findVariable(this.leftTerm);
        if (nv == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        GNode ndest = s.findNext(nv);
        if (ndest == null || ndest.getType() != 4) {
            return "I can't find the node pointed to by " + this.leftTerm + ".";
        }
        s.deleteNode(ndest);
        return null;
    }

    public String toString() {
        if (Parameters.isCodeStyleJava()) {
            return "delete " + this.leftTerm + ";";
        }
        if (Parameters.isCodeStyleCpp()) {
            return "delete " + this.leftTerm + ";";
        }
        return "";
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        String left = mapping.mappingOf(this.leftTerm);
        DeleteNode clone = new DeleteNode(left);
        return clone;
    }
}

