/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.model.StateSpace;
import ilist.statement.LogicFormula;

public class Disjunction
extends LogicFormula {
    private static final long serialVersionUID = 1L;
    private LogicFormula term1;
    private LogicFormula term2;

    public Disjunction(LogicFormula term1, LogicFormula term2) {
        this.term1 = term1;
        this.term2 = term2;
    }

    @Override
    public String check(StateSpace s) {
        String err1 = this.term1.check(s);
        if (err1 != null) {
            return err1;
        }
        String err2 = this.term2.check(s);
        if (err2 == null || this.term1.evaluate(s)) {
            return null;
        }
        return err2;
    }

    @Override
    public boolean evaluate(StateSpace s) {
        return this.term1.evaluate(s) || this.term2.evaluate(s);
    }

    public String toString() {
        return this.term1 + " || " + this.term2;
    }
}

