/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.LogicFormula;
import ilist.statement.Statement;
import java.util.List;
import java.util.Vector;

public class Loop
extends Statement {
    private static final long serialVersionUID = 1L;
    private LogicFormula condition;
    private Vector<Statement> body;

    public Loop(LogicFormula condition) {
        this.condition = condition;
        this.body = new Vector();
    }

    @Override
    public String execute(StateSpace s) {
        boolean exit = false;
        int count = 0;
        while (!exit) {
            if (++count == 100) {
                return "I got into an infinite loop.";
            }
            String conditionError = this.condition.check(s);
            if (conditionError != null) {
                return "in iteration #" + count + ", the condition\nif (" + this.condition + ") ...\ncannot be evaluated.\n" + conditionError;
            }
            if (this.condition.evaluate(s)) {
                for (Statement st : this.body) {
                    String stError = st.execute(s);
                    if (stError == null) continue;
                    return "in iteration #" + count + ", when I tried to execute\n" + st + "\n" + stError;
                }
                continue;
            }
            exit = true;
        }
        return null;
    }

    public void addToBody(Statement st) {
        this.body.add(st);
    }

    public void addToBody(int index, Statement st) {
        this.body.add(index, st);
    }

    public void removeFromBody(Statement st) {
        this.body.remove(st);
    }

    public void removeFromBody(int index) {
        this.body.remove(index);
    }

    public void clearBody() {
        this.body.clear();
    }

    public int bodySize() {
        return this.body.size();
    }

    public void setBody(List<Statement> statements) {
        this.body.clear();
        this.body.addAll(statements);
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("while (");
        s.append(this.condition);
        s.append(") {\n");
        for (Statement st : this.body) {
            s.append("  ");
            s.append(st.toString().replace("\n", "\n  "));
            s.append("\n");
        }
        s.append("}");
        return s.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.condition == null ? 0 : this.condition.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Loop other = (Loop)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        return !(this.condition == null ? other.condition != null : !this.condition.equals(other.condition));
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        Loop clone = new Loop(this.condition);
        for (Statement s : this.body) {
            clone.body.add(s.morphedClone(mapping));
        }
        return clone;
    }
}

