/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.statement.Comparison;

public class NextEqNull
extends Comparison {
    private static final long serialVersionUID = 1L;

    public NextEqNull(String leftTerm, boolean notEqual) {
        this.leftTerm = leftTerm;
        this.notEqual = notEqual;
    }

    @Override
    public String check(StateSpace s) {
        if (this.leftTerm == null) {
            return "The left term is null.";
        }
        GNode vLeft = s.findVariable(this.leftTerm);
        if (vLeft == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        GNode nLeft = s.findNext(s.findNext(vLeft));
        if (nLeft == null) {
            return "I can't find the next of the node pointed to by " + this.leftTerm + ".";
        }
        return null;
    }

    @Override
    public boolean evaluate(StateSpace s) {
        GNode vLeft = s.findVariable(this.leftTerm);
        GNode nLeft = s.findNext(s.findNext(vLeft));
        boolean equality = nLeft == StateSpace.nNull;
        return equality ^ this.notEqual;
    }

    public String toString() {
        String op;
        String string = op = this.notEqual ? " != " : " == ";
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + ".link" + op + "null";
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + "->link" + op + "NULL";
        }
        return "";
    }
}

