/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.statement.Comparison;

public class NextEqVar
extends Comparison {
    private static final long serialVersionUID = 1L;

    public NextEqVar(String leftTerm, String rightTerm, boolean notEqual) {
        this.leftTerm = leftTerm;
        this.rightTerm = rightTerm;
        this.notEqual = notEqual;
    }

    @Override
    public String check(StateSpace s) {
        if (this.leftTerm == null || this.rightTerm == null) {
            return "The left term, right term, or both are null.";
        }
        GNode vLeft = s.findVariable(this.leftTerm);
        GNode vRight = s.findVariable(this.rightTerm);
        if (vLeft == null && vRight == null) {
            return "Variables " + this.leftTerm + " and " + this.rightTerm + " do not exist.";
        }
        if (vLeft == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        if (vRight == null) {
            return "Variable " + this.rightTerm + " does not exist.";
        }
        GNode nLeft = s.findNext(s.findNext(vLeft));
        GNode nRight = s.findNext(vRight);
        if (nLeft == null && nRight == null) {
            return "I can't find neither the next of the node pointed to by " + this.leftTerm + "nor the node pointed to by " + this.rightTerm + ".";
        }
        if (nLeft == null) {
            return "I can't find the next of the node pointed to by " + this.leftTerm + ".";
        }
        if (nRight == null) {
            return "I can't find the node pointed to by " + this.rightTerm + ".";
        }
        return null;
    }

    @Override
    public boolean evaluate(StateSpace s) {
        GNode nRight;
        GNode vLeft = s.findVariable(this.leftTerm);
        GNode vRight = s.findVariable(this.rightTerm);
        GNode nLeft = s.findNext(s.findNext(vLeft));
        boolean equality = nLeft == (nRight = s.findNext(vRight));
        return equality ^ this.notEqual;
    }

    public String toString() {
        String op;
        String string = op = this.notEqual ? " != " : " == ";
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + ".link" + op + this.rightTerm;
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + "->link" + op + this.rightTerm;
        }
        return "";
    }
}

