/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;

public class NodeCreation
extends Statement {
    private static final long serialVersionUID = 1L;

    public NodeCreation(String leftTerm) {
        this.leftTerm = leftTerm;
    }

    @Override
    public String execute(StateSpace s) {
        GNode nv = s.findVariable(this.leftTerm);
        if (nv == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        GNode nn = s.createNode("?");
        s.link(nv, nn);
        return null;
    }

    public String toString() {
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + " = new Node();";
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + " = new Node;";
        }
        return "";
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        String left = mapping.mappingOf(this.leftTerm);
        NodeCreation clone = new NodeCreation(left);
        return clone;
    }
}

