/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;

public class NullToNext
extends Statement {
    private static final long serialVersionUID = 1L;

    public NullToNext(String leftTerm) {
        this.leftTerm = leftTerm;
    }

    @Override
    public String execute(StateSpace s) {
        GNode nv1 = s.findVariable(this.leftTerm);
        if (nv1 == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        GNode ndest = s.findNext(nv1);
        if (ndest == null || ndest.getType() != 4) {
            return "I can't find the node pointed to by " + this.leftTerm + ".";
        }
        s.link(ndest, StateSpace.nNull);
        return null;
    }

    public String toString() {
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + ".link = null;";
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + "->link = NULL;";
        }
        return "";
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        String left = mapping.mappingOf(this.leftTerm);
        NullToNext clone = new NullToNext(left);
        return clone;
    }
}

