/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;

public class RemoveVariable
extends Statement {
    private static final long serialVersionUID = 1L;

    public RemoveVariable(String leftTerm) {
        this.leftTerm = leftTerm;
    }

    @Override
    public String execute(StateSpace s) {
        if (!s.removeVariable(this.leftTerm)) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        return null;
    }

    public String toString() {
        if (Parameters.isCodeStyleJava()) {
            return "remove " + this.leftTerm + ";";
        }
        if (Parameters.isCodeStyleCpp()) {
            return "remove " + this.leftTerm + ";";
        }
        return "";
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        String left = mapping.mappingOf(this.leftTerm);
        RemoveVariable clone = new RemoveVariable(left);
        return clone;
    }
}

