/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.statement.Block;
import ilist.statement.Comparison;
import ilist.statement.ComparisonParser;
import ilist.statement.ConstToData;
import ilist.statement.DataToData;
import ilist.statement.Declaration;
import ilist.statement.DeleteNode;
import ilist.statement.Loop;
import ilist.statement.NextToNext;
import ilist.statement.NextToVar;
import ilist.statement.NodeCreation;
import ilist.statement.NullToNext;
import ilist.statement.NullToVar;
import ilist.statement.RemoveVariable;
import ilist.statement.Statement;
import ilist.statement.VarToNext;
import ilist.statement.VarToVar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SimpleParser {
    private Pattern p1 = Pattern.compile("(?i:node)\\*?([a-zA-Z_]\\w*);?");
    private Pattern p1a = Pattern.compile("(?i:node)\\*?([a-zA-Z_]\\w*)=(?i:new)(?i:node)?(?:\\(\\))?;?");
    private Pattern p2 = Pattern.compile("([a-zA-Z_]\\w*)=(?i:new)(?i:node)?(?:\\(\\))?;?");
    private Pattern p3 = Pattern.compile("([a-zA-Z_]\\w*)=(?i:null|0);?");
    private Pattern p4 = Pattern.compile("([a-zA-Z_]\\w*)=([a-zA-Z_]\\w*)(?:\\.|->)(?i:next|link);?");
    private Pattern p5 = Pattern.compile("([a-zA-Z_]\\w*)=([a-zA-Z_]\\w*);?");
    private Pattern p6 = Pattern.compile("([a-zA-Z_]\\w*)(?:\\.|->)(?i:data|info)=(?:\"(.*)\"|(\\d+));?");
    private Pattern p7 = Pattern.compile("([a-zA-Z_]\\w*)(?:\\.|->)(?i:data|info)=([a-zA-Z_]\\w*)(?:\\.|->)(?i:data|info);?");
    private Pattern p8 = Pattern.compile("([a-zA-Z_]\\w*)(?:\\.|->)(?i:next|link)=(?i:null|0);?");
    private Pattern p9 = Pattern.compile("([a-zA-Z_]\\w*)(?:\\.|->)(?i:next|link)=([a-zA-Z_]\\w*)(?:\\.|->)(?i:next|link);?");
    private Pattern p10 = Pattern.compile("([a-zA-Z_]\\w*)(?:\\.|->)(?i:next|link)=([a-zA-Z_]\\w*);?");
    private Pattern p11 = Pattern.compile("(?i:delete)([a-zA-Z_]\\w*);?");
    private Pattern p12 = Pattern.compile("(?i)remove([a-zA-Z_]\\w*);?");
    private Pattern p13 = Pattern.compile("(?i)while\\((.+)\\)(?:\\{.*\\})?;?");
    private ComparisonParser comparisonParser = new ComparisonParser();

    public static void main(String[] argv) {
        SimpleParser par = new SimpleParser();
        System.out.println(par.parse(argv[0]));
    }

    public Statement parse(String s) {
        Matcher m = this.p1.matcher(s = s.replaceAll("\\s", ""));
        if (m.matches()) {
            return new Declaration(m.group(1).toUpperCase());
        }
        m = this.p1a.matcher(s);
        if (m.matches()) {
            Block b = new Block();
            Declaration st1 = new Declaration(m.group(1).toUpperCase());
            NodeCreation st2 = new NodeCreation(m.group(1).toUpperCase());
            b.addToBody(st1);
            b.addToBody(st2);
            return b;
        }
        m = this.p2.matcher(s);
        if (m.matches()) {
            return new NodeCreation(m.group(1).toUpperCase());
        }
        m = this.p3.matcher(s);
        if (m.matches()) {
            return new NullToVar(m.group(1).toUpperCase());
        }
        m = this.p4.matcher(s);
        if (m.matches()) {
            return new NextToVar(m.group(1).toUpperCase(), m.group(2).toUpperCase());
        }
        m = this.p5.matcher(s);
        if (m.matches()) {
            return new VarToVar(m.group(1).toUpperCase(), m.group(2).toUpperCase());
        }
        m = this.p6.matcher(s);
        if (m.matches()) {
            String dataField = m.group(2) != null ? m.group(2).toUpperCase() : m.group(3).toUpperCase();
            return new ConstToData(m.group(1).toUpperCase(), dataField);
        }
        m = this.p7.matcher(s);
        if (m.matches()) {
            return new DataToData(m.group(1).toUpperCase(), m.group(2).toUpperCase());
        }
        m = this.p8.matcher(s);
        if (m.matches()) {
            return new NullToNext(m.group(1).toUpperCase());
        }
        m = this.p9.matcher(s);
        if (m.matches()) {
            return new NextToNext(m.group(1).toUpperCase(), m.group(2).toUpperCase());
        }
        m = this.p10.matcher(s);
        if (m.matches()) {
            return new VarToNext(m.group(1).toUpperCase(), m.group(2).toUpperCase());
        }
        m = this.p11.matcher(s);
        if (m.matches()) {
            return new DeleteNode(m.group(1).toUpperCase());
        }
        m = this.p12.matcher(s);
        if (m.matches()) {
            return new RemoveVariable(m.group(1).toUpperCase());
        }
        m = this.p13.matcher(s);
        if (m.matches()) {
            String sCondition = m.group(1);
            Comparison cCondition = this.comparisonParser.parse(sCondition);
            if (cCondition != null) {
                return new Loop(cCondition);
            }
            return null;
        }
        return null;
    }
}

