/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.statement.Comparison;

public class VarEqNull
extends Comparison {
    private static final long serialVersionUID = 1L;

    public VarEqNull(String leftTerm, boolean notEqual) {
        this.leftTerm = leftTerm;
        this.notEqual = notEqual;
    }

    @Override
    public String check(StateSpace s) {
        if (this.leftTerm == null) {
            return "The left term is null.";
        }
        GNode left = s.findVariable(this.leftTerm);
        if (left == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        return null;
    }

    @Override
    public boolean evaluate(StateSpace s) {
        GNode vLeft = s.findVariable(this.leftTerm);
        GNode nLeft = s.findNext(vLeft);
        boolean equality = nLeft == StateSpace.nNull;
        return equality ^ this.notEqual;
    }

    public String toString() {
        String op;
        String string = op = this.notEqual ? " != " : " == ";
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + op + "null";
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + op + "NULL";
        }
        return "";
    }
}

