/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.statement.Comparison;

public class VarEqVar
extends Comparison {
    private static final long serialVersionUID = 1L;

    public VarEqVar(String leftTerm, String rightTerm, boolean notEqual) {
        this.leftTerm = leftTerm;
        this.rightTerm = rightTerm;
        this.notEqual = notEqual;
    }

    @Override
    public String check(StateSpace s) {
        if (this.leftTerm == null || this.rightTerm == null) {
            return "The left term, right term, or both are null.";
        }
        GNode left = s.findVariable(this.leftTerm);
        GNode right = s.findVariable(this.rightTerm);
        if (left == null && right == null) {
            return "Variables " + this.leftTerm + " and " + this.rightTerm + " do not exist.";
        }
        if (left == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        if (right == null) {
            return "Variable " + this.rightTerm + " does not exist.";
        }
        return null;
    }

    @Override
    public boolean evaluate(StateSpace s) {
        GNode nRight;
        GNode vLeft = s.findVariable(this.leftTerm);
        GNode vRight = s.findVariable(this.rightTerm);
        GNode nLeft = s.findNext(vLeft);
        boolean equality = nLeft == (nRight = s.findNext(vRight));
        return equality ^ this.notEqual;
    }

    public String toString() {
        return String.valueOf(this.leftTerm) + (this.notEqual ? " != " : " == ") + this.rightTerm;
    }
}

