/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;

public class VarToNext
extends Statement {
    private static final long serialVersionUID = 1L;

    public VarToNext(String leftTerm, String rightTerm) {
        this.leftTerm = leftTerm;
        this.rightTerm = rightTerm;
    }

    @Override
    public String execute(StateSpace s) {
        GNode nv1 = s.findVariable(this.leftTerm);
        GNode nv2 = s.findVariable(this.rightTerm);
        if (nv1 == null && nv2 == null && !this.leftTerm.equals(this.rightTerm)) {
            return "Variables " + this.leftTerm + " and " + this.rightTerm + " do not exist.";
        }
        if (nv1 == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        if (nv2 == null) {
            return "Variable " + this.rightTerm + " does not exist.";
        }
        GNode nsource = s.findNext(nv1);
        GNode ndest = s.findNext(nv2);
        if (!(nsource != null && nsource.getType() == 4 || ndest != null || this.leftTerm.equals(this.rightTerm))) {
            return "I can't find neither the node pointed to by " + this.leftTerm + "nor the node pointed to by " + this.rightTerm + ".";
        }
        if (nsource == null || nsource.getType() != 4) {
            return "I can't find the node pointed to by " + this.leftTerm + ".";
        }
        if (ndest == null) {
            return "I can't find the node pointed to by " + this.rightTerm + ".";
        }
        s.link(nsource, ndest);
        return null;
    }

    public String toString() {
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + ".link = " + this.rightTerm + ";";
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + "->link = " + this.rightTerm + ";";
        }
        return "";
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        String left = mapping.mappingOf(this.leftTerm);
        String right = mapping.mappingOf(this.rightTerm);
        VarToNext clone = new VarToNext(left, right);
        return clone;
    }
}

