/*
 * Decompiled with CFR 0.152.
 */
package ilist.statement;

import ilist.misc.Parameters;
import ilist.model.GNode;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.statement.Statement;

public class VarToVar
extends Statement {
    private static final long serialVersionUID = 1L;

    public VarToVar(String leftTerm, String rightTerm) {
        this.leftTerm = leftTerm;
        this.rightTerm = rightTerm;
    }

    @Override
    public String execute(StateSpace s) {
        GNode nv1 = s.findVariable(this.leftTerm);
        GNode nv2 = s.findVariable(this.rightTerm);
        if (nv1 == null && nv2 == null && !this.leftTerm.equals(this.rightTerm)) {
            return "Variables " + this.leftTerm + " and " + this.rightTerm + " do not exist.";
        }
        if (nv1 == null) {
            return "Variable " + this.leftTerm + " does not exist.";
        }
        if (nv2 == null) {
            return "Variable " + this.rightTerm + " does not exist.";
        }
        GNode ndest = s.findNext(nv2);
        if (ndest == null) {
            return "I can't find the node pointed to by " + this.rightTerm + ".";
        }
        s.link(nv1, ndest);
        return null;
    }

    public String toString() {
        if (Parameters.isCodeStyleJava()) {
            return String.valueOf(this.leftTerm) + " = " + this.rightTerm + ";";
        }
        if (Parameters.isCodeStyleCpp()) {
            return String.valueOf(this.leftTerm) + " = " + this.rightTerm + ";";
        }
        return "";
    }

    @Override
    public Statement morphedClone(VariableMapping mapping) {
        String left = mapping.mappingOf(this.leftTerm);
        String right = mapping.mappingOf(this.rightTerm);
        VarToVar clone = new VarToVar(left, right);
        return clone;
    }
}

