/*
 * Decompiled with CFR 0.152.
 */
package ilist.supermodel;

import ilist.model.VariableMapping;
import ilist.statement.NoOp;
import ilist.statement.Statement;
import ilist.supermodel.SNode;

public class ActionNode
extends SNode {
    private static final long serialVersionUID = 1L;
    public static ActionNode START = new ActionNode(new NoOp("START"));
    public static ActionNode UNDO = new ActionNode(new NoOp("UNDO"));
    public static ActionNode REDO = new ActionNode(new NoOp("REDO"));
    private Statement statement;

    public ActionNode(Statement st) {
        this.statement = st;
    }

    public ActionNode(ActionNode action, VariableMapping mapping) {
        this.statement = action.statement.morphedClone(mapping);
    }

    @Override
    public boolean isEquivalent(SNode other) {
        if (other instanceof ActionNode) {
            return this.statement.equals(((ActionNode)other).statement);
        }
        return false;
    }

    @Override
    public String dotNodeID(int nodeNumber) {
        return "A" + nodeNumber;
    }

    @Override
    public String dotNodeDefinition(int nodeNumber) {
        return String.format("%s [fontsize=40,label=\"%s\",shape=parallelogram,style=bold];", this.dotNodeID(nodeNumber), this.toString());
    }

    public String toString() {
        return this.statement.toString().replace('\n', ' ');
    }
}

