/*
 * Decompiled with CFR 0.152.
 */
package ilist.supermodel;

import ilist.misc.StatisticalAggregator;
import java.io.Serializable;

public abstract class SNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    boolean onBestPath = false;
    int frequency = 1;
    double goodness = -1.0;
    StatisticalAggregator timeToExit = new StatisticalAggregator();
    StatisticalAggregator undoUncertainty = new StatisticalAggregator();
    int undoCount = 0;
    double criticality = -1.0;
    double goodnessMass = -1.0;

    public abstract boolean isEquivalent(SNode var1);

    public abstract String dotNodeID(int var1);

    public abstract String dotNodeDefinition(int var1);

    public int getFrequency() {
        return this.frequency;
    }

    public int increaseFrequency() {
        return ++this.frequency;
    }

    public double getGoodness() {
        return this.goodness;
    }

    public double getGoodnessMass() {
        return this.goodnessMass;
    }

    public void setGoodness(double goodness) {
        this.goodness = goodness;
        this.goodnessMass = (double)this.frequency * goodness;
    }

    public String getColor(double nodeStrength) {
        int color_r = 0;
        int color_g = 0;
        int color_b = 0;
        if (this.goodness < 0.0) {
            color_r = 255;
            color_g = 255;
            color_b = 255;
        } else if (this.goodness < 0.5) {
            color_r = 255;
            color_g = (int)(510.0 * this.goodness);
        } else if (this.goodness <= 1.0) {
            color_r = (int)(510.0 * (1.0 - this.goodness));
            color_g = 255;
        }
        double[] color_hsl = this.rgb2hsl(color_r, color_g, color_b);
        color_hsl[1] = color_hsl[1] * nodeStrength;
        int[] color_rgb = this.hsl2rgb(color_hsl);
        String color = String.format("#%02x%02x%02x", color_rgb[0], color_rgb[1], color_rgb[2]);
        return color;
    }

    private double[] rgb2hsl(int r, int g, int b) {
        float S;
        float var_Max;
        float var_Min;
        float var_R = (float)r / 255.0f;
        float var_G = (float)g / 255.0f;
        float var_B = (float)b / 255.0f;
        if (var_R > var_G) {
            var_Min = var_G;
            var_Max = var_R;
        } else {
            var_Min = var_R;
            var_Max = var_G;
        }
        if (var_B > var_Max) {
            var_Max = var_B;
        }
        if (var_B < var_Min) {
            var_Min = var_B;
        }
        float del_Max = var_Max - var_Min;
        float H = 0.0f;
        float L = (var_Max + var_Min) / 2.0f;
        if (del_Max == 0.0f) {
            H = 0.0f;
            S = 0.0f;
        } else {
            S = (double)L < 0.5 ? del_Max / (var_Max + var_Min) : del_Max / (2.0f - var_Max - var_Min);
            float del_R = ((var_Max - var_R) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_G = ((var_Max - var_G) / 6.0f + del_Max / 2.0f) / del_Max;
            float del_B = ((var_Max - var_B) / 6.0f + del_Max / 2.0f) / del_Max;
            if (var_R == var_Max) {
                H = del_B - del_G;
            } else if (var_G == var_Max) {
                H = 0.33333334f + del_R - del_B;
            } else if (var_B == var_Max) {
                H = 0.6666667f + del_G - del_R;
            }
            if (H < 0.0f) {
                H += 1.0f;
            }
            if (H > 1.0f) {
                H -= 1.0f;
            }
        }
        double[] hsl = new double[]{H, S, L};
        return hsl;
    }

    private int[] hsl2rgb(double[] hsl) {
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        double H = hsl[0];
        double S = hsl[1];
        double L = hsl[2];
        if (L == 0.0) {
            r = 0.0;
            g = 0.0;
            b = 0.0;
        } else if (S == 0.0) {
            r = L;
            g = L;
            b = L;
        } else {
            double temp2 = L <= 0.5 ? L * (1.0 + S) : L + S - L * S;
            double temp1 = 2.0 * L - temp2;
            double[] t3 = new double[]{H + 0.3333333333333333, H, H - 0.3333333333333333};
            double[] clr = new double[]{0.0, 0.0, 0.0};
            int i = 0;
            while (i < 3) {
                if (t3[i] < 0.0) {
                    int n = i;
                    t3[n] = t3[n] + 1.0;
                }
                if (t3[i] > 1.0) {
                    int n = i;
                    t3[n] = t3[n] - 1.0;
                }
                clr[i] = 6.0 * t3[i] < 1.0 ? temp1 + (temp2 - temp1) * t3[i] * 6.0 : (2.0 * t3[i] < 1.0 ? temp2 : (3.0 * t3[i] < 2.0 ? temp1 + (temp2 - temp1) * (0.6666666666666666 - t3[i]) * 6.0 : temp1));
                ++i;
            }
            r = clr[0];
            g = clr[1];
            b = clr[2];
        }
        return new int[]{(int)(255.0 * r), (int)(255.0 * g), (int)(255.0 * b)};
    }

    public void addTimeToExit(double seconds) {
        this.timeToExit.addSample(seconds);
    }

    public double meanTimeToExit() {
        return this.timeToExit.mean();
    }

    public double stdevTimeToExit() {
        return this.timeToExit.stdev();
    }

    public double meanPreviousTimeToExit() {
        return this.timeToExit.previousMean();
    }

    public double stdevPreviousTimeToExit() {
        return this.timeToExit.previousStdev();
    }

    public void addUndoUncertainty(double x) {
        this.undoUncertainty.addSample(x);
    }

    public double meanUndoUncertainty() {
        return this.undoUncertainty.mean();
    }

    public double stdevUndoUncertainty() {
        return this.undoUncertainty.stdev();
    }

    public boolean isOnBestPath() {
        return this.onBestPath;
    }

    public void setOnBestPath(boolean onBestPath) {
        this.onBestPath = onBestPath;
    }

    public void increaseUndoCount() {
        ++this.undoCount;
    }

    public void resetUndoCount() {
        this.undoCount = 0;
    }

    public int getUndoCount() {
        return this.undoCount;
    }

    public double getCriticality() {
        return this.criticality;
    }

    public void setCriticality(double criticality) {
        this.criticality = criticality;
    }
}

