/*
 * Decompiled with CFR 0.152.
 */
package ilist.supermodel;

import ilist.misc.ExponentialSmoother;
import ilist.model.VariableMapping;
import ilist.supermodel.ActionNode;
import ilist.supermodel.StateNode;
import java.io.Serializable;
import java.util.Stack;
import java.util.Vector;

public class SolutionPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String session;
    private String modelID;
    private Vector<PathRecord> path;
    private Stack<PathRecord> undoStack;
    private Stack<PathRecord> redoStack;
    private ExponentialSmoother undoBehavior;
    private ExponentialSmoother timeOffset;
    private ExponentialSmoother studentCorrectness;

    public SolutionPath(String session, String modelID) {
        this.session = session;
        this.modelID = modelID;
        this.path = new Vector();
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.undoBehavior = new ExponentialSmoother(0.5);
        this.timeOffset = new ExponentialSmoother(0.1);
        this.studentCorrectness = new ExponentialSmoother(0.5);
    }

    public void add(long timestamp, ActionNode action, StateNode state, VariableMapping mapping, ActionNode mappedAction, StateNode mappedState) {
        double stateGoodness;
        if (!this.path.isEmpty()) {
            this.undoStack.push(this.path.lastElement());
        }
        this.redoStack.clear();
        PathRecord record = new PathRecord(timestamp, action, state, mapping, mappedAction, mappedState);
        this.path.add(record);
        this.undoBehavior.addSample(0.0);
        StateNode prevState = this.getPenultimateState();
        if (prevState != null) {
            double meanTime = prevState.meanTimeToExit();
            double stdevTime = prevState.stdevTimeToExit();
            double off = stdevTime > 0.0 ? (this.getTimeLag() - meanTime) / stdevTime : 0.0;
            this.timeOffset.addSample(off);
        }
        if ((stateGoodness = mappedState.getGoodness()) == 0.0) {
            this.studentCorrectness.addSample(0.0);
        } else if (stateGoodness > 0.0) {
            this.studentCorrectness.addSample(1.0);
        }
    }

    public void start(long timestamp, StateNode state) {
        if (this.path.isEmpty()) {
            this.undoStack.clear();
            this.redoStack.clear();
            PathRecord rec = new PathRecord(timestamp, ActionNode.START, state, new VariableMapping(), ActionNode.START, state);
            this.path.add(rec);
            this.studentCorrectness.clear(state.getGoodness());
        } else {
            this.undoStack.clear();
            this.redoStack.clear();
            PathRecord rec = new PathRecord(this.path.firstElement());
            rec.timestamp = timestamp;
            rec.action = ActionNode.START;
            rec.mappedAction = ActionNode.START;
            this.path.add(rec);
            this.undoBehavior.addSample(1.0);
            this.timeOffset.clear(0.0);
        }
    }

    public void undo(long timestamp) {
        if (!this.undoStack.isEmpty()) {
            this.redoStack.push(this.path.lastElement());
            PathRecord rec = new PathRecord(this.undoStack.pop());
            rec.timestamp = timestamp;
            rec.action = ActionNode.UNDO;
            rec.mappedAction = ActionNode.UNDO;
            this.path.add(rec);
            this.undoBehavior.addSample(1.0);
        }
    }

    public void redo(long timestamp) {
        if (!this.redoStack.isEmpty()) {
            this.undoStack.push(this.path.lastElement());
            PathRecord rec = new PathRecord(this.redoStack.pop());
            rec.timestamp = timestamp;
            rec.action = ActionNode.REDO;
            this.path.add(rec);
            this.undoBehavior.addSample(1.0);
        }
    }

    public boolean isEmpty() {
        return this.path.isEmpty();
    }

    public StateNode getFirstState() {
        if (this.path.isEmpty()) {
            return null;
        }
        return this.path.firstElement().mappedState;
    }

    public ActionNode getFirstAction() {
        if (this.path.isEmpty()) {
            return null;
        }
        return this.path.firstElement().mappedAction;
    }

    public StateNode getLastState() {
        if (this.path.isEmpty()) {
            return null;
        }
        return this.path.lastElement().mappedState;
    }

    public StateNode getLastRawState() {
        if (this.path.isEmpty()) {
            return null;
        }
        return this.path.lastElement().state;
    }

    public StateNode getPenultimateState() {
        int psize = this.path.size();
        if (psize < 2) {
            return null;
        }
        return this.path.elementAt((int)(psize - 2)).mappedState;
    }

    public StateNode getPenultimateRawState() {
        int psize = this.path.size();
        if (psize < 2) {
            return null;
        }
        return this.path.elementAt((int)(psize - 2)).state;
    }

    public ActionNode getLastAction() {
        if (this.path.isEmpty()) {
            return null;
        }
        return this.path.lastElement().mappedAction;
    }

    public VariableMapping getLastMapping() {
        if (this.path.isEmpty()) {
            return null;
        }
        return this.path.lastElement().mapping;
    }

    public VariableMapping disambiguateMapping(Vector<VariableMapping> mappings) {
        if (mappings == null || mappings.isEmpty()) {
            return new VariableMapping();
        }
        if (mappings.size() == 1) {
            return mappings.firstElement();
        }
        VariableMapping lastStepMapping = this.path.lastElement().mapping;
        for (VariableMapping potentialMapping : mappings) {
            if (!potentialMapping.isCompatible(lastStepMapping)) continue;
            return potentialMapping;
        }
        return mappings.firstElement();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("<path session=\"" + this.session + "\">\n");
        for (PathRecord r : this.path) {
            sb.append(String.valueOf(r.toString()) + "\n");
        }
        sb.append("</path>\n");
        return sb.toString();
    }

    public String getSession() {
        return this.session;
    }

    public double getUndoBehavior() {
        return this.undoBehavior.getValue();
    }

    public double getTimeOffset() {
        return this.timeOffset.getValue();
    }

    public double getPreviousTimeOffset() {
        return this.timeOffset.getPreviousValue();
    }

    public double getTimeLag() {
        int psize = this.path.size();
        if (psize < 2) {
            return 0.0;
        }
        return (double)(this.path.elementAt((int)(psize - 1)).timestamp - this.path.elementAt((int)(psize - 2)).timestamp) / 1000.0;
    }

    public double getStudentCorrectness() {
        return this.studentCorrectness.getValue();
    }

    public int getLength() {
        return this.path.size();
    }

    public double getAverageGoodness() {
        double result = 0.0;
        int n = 0;
        for (PathRecord pr : this.path) {
            double goodness = pr.mappedState.getGoodness();
            if (!(goodness >= 0.0)) continue;
            result += goodness;
            ++n;
        }
        result = n > 0 ? (result /= (double)n) : -1.0;
        return result;
    }

    public double getTotalTime() {
        double result = 0.0;
        if (this.path.size() >= 2) {
            long ts1 = this.path.firstElement().timestamp;
            long ts2 = this.path.lastElement().timestamp;
            result = (double)(ts2 - ts1) / 1000.0;
        }
        return result;
    }

    public static String statisticsHeader() {
        return "model,session,moves,total_time,avg_goodness";
    }

    public String statistics() {
        return String.valueOf(this.modelID) + "," + this.session + "," + this.getLength() + "," + this.getTotalTime() + "," + this.getAverageGoodness();
    }

    private class PathRecord
    implements Serializable {
        private static final long serialVersionUID = 1L;
        long timestamp;
        ActionNode action;
        StateNode state;
        VariableMapping mapping;
        ActionNode mappedAction;
        StateNode mappedState;

        PathRecord(long timestamp, ActionNode action, StateNode state, VariableMapping mapping, ActionNode mappedAction, StateNode mappedState) {
            this.timestamp = timestamp;
            this.action = action;
            this.state = state;
            this.mapping = mapping;
            this.mappedAction = mappedAction;
            this.mappedState = mappedState;
        }

        PathRecord(PathRecord other) {
            this.timestamp = other.timestamp;
            this.action = other.action;
            this.state = other.state;
            this.mapping = other.mapping;
            this.mappedAction = other.mappedAction;
            this.mappedState = other.mappedState;
        }

        public String toString() {
            return "(" + this.timestamp + ", \"" + this.action + "\", " + this.state + ", " + this.mapping + ", \"" + this.mappedAction + "\", " + this.mappedState + ")";
        }
    }
}

