/*
 * Decompiled with CFR 0.152.
 */
package ilist.supermodel;

import ilist.model.LinkedListModel;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.supermodel.SNode;
import java.util.Vector;

public class StateNode
extends SNode {
    private static final long serialVersionUID = 1L;
    private StateSpace space;
    private boolean correctSolution = false;

    public StateNode() {
        this.space = new StateSpace();
    }

    public StateNode(LinkedListModel model) {
        this.space = model.getStateSpaces().firstElement();
    }

    public StateNode(StateNode state, VariableMapping mapping) {
        this.space = new StateSpace(state.space, mapping);
    }

    @Override
    public boolean isEquivalent(SNode other) {
        return this.equals(other);
    }

    public Vector<VariableMapping> variableMappings(StateNode other) {
        return this.space.variableMappings(other.space);
    }

    public Vector<String> variableList() {
        if (this.space != null) {
            return this.space.variableList();
        }
        return null;
    }

    public Vector<String> notTemporaryVariableList() {
        if (this.space != null) {
            return this.space.notTemporaryVariableList();
        }
        return null;
    }

    @Override
    public String dotNodeID(int nodeNumber) {
        return "S" + nodeNumber;
    }

    @Override
    public String dotNodeDefinition(int nodeNumber) {
        String id = this.dotNodeID(nodeNumber);
        String shape = this.correctSolution ? "doublecircle" : "circle";
        shape = "box";
        double thickness = this.goodness * 10.0 + 2.0;
        String label = String.format("%s, g=%.2f", id, this.goodness);
        return String.valueOf(id) + " " + "[fontsize=40,label=\"" + label + "\",shape=\"" + shape + "\",style=\"setlinewidth(" + thickness + ")\"];";
    }

    public String toDOT(int nodeNumber, double nodeStrength) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph " + this.dotNodeID(nodeNumber) + " {\n");
        sb.append(String.format("  fontsize=40;\n  label=\"g = %.2f c = %.2f\";\n", this.goodness, this.criticality));
        sb.append("  bgcolor=\"" + this.getColor(nodeStrength) + "\";\n");
        sb.append(this.space.partialDOT());
        sb.append("}\n");
        return sb.toString();
    }

    public boolean isCorrectSolution() {
        return this.correctSolution;
    }

    public void setCorrectSolution(boolean correctSolution) {
        this.correctSolution = correctSolution;
    }

    public StateSpace getStateSpace() {
        return this.space;
    }
}

