/*
 * Decompiled with CFR 0.152.
 */
package ilist.supermodel;

import edu.uic.cs.nlp.chiqat.plugin.linkedlistplugin.constraints.Evaluator;
import ilist.misc.StatisticalAggregator;
import ilist.model.LinkedListModel;
import ilist.model.StateSpace;
import ilist.model.VariableMapping;
import ilist.model.VariableNameGenerator;
import ilist.statement.NoOp;
import ilist.supermodel.ActionNode;
import ilist.supermodel.ActionRecord;
import ilist.supermodel.SEdge;
import ilist.supermodel.SNode;
import ilist.supermodel.SessionStats;
import ilist.supermodel.SolutionPath;
import ilist.supermodel.SpecialNode;
import ilist.supermodel.StateNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import org.jgrapht.GraphPath;
import org.jgrapht.Graphs;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.graph.DefaultDirectedWeightedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jgrapht.traverse.DepthFirstIterator;

public class SuperModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected DefaultDirectedWeightedGraph<SNode, SEdge> graph;
    private UndirectedGraph<SNode, SEdge> graphUndirectedView;
    private HashMap<String, SolutionPath> solutionPaths;
    private HashMap<String, SessionStats> sessionStats;
    private TreeSet<String> sessionSet;
    private ArrayList<String> sessionList;
    private StatisticalAggregator bestPathGoodnessDifferential = new StatisticalAggregator();
    private SpecialNode ROOT = new SpecialNode("START", "cyan");
    private SpecialNode SUCCESS = new SpecialNode("SUCCESS", "cyan");
    private ActionNode START = new ActionNode(new NoOp("START"));
    private ActionNode SUBMIT = new ActionNode(new NoOp("SUCCESS"));
    private StateNode firstState = null;
    private int addCount = 0;
    private int isomorphismCheckCount = 0;
    private int matchedStateNodeCount = 0;
    private int matchedActionNodeCount = 0;
    private VariableNameGenerator variableNameGenerator;
    private double frequencyMass = 0.0;
    private double goodnessMass = 0.0;
    private StatisticalAggregator frequencyStats = new StatisticalAggregator();

    public SuperModel(String id) {
        this.id = id;
        this.graph = new DefaultDirectedWeightedGraph(SEdge.class);
        this.graph.addVertex((Object)this.ROOT);
        this.graph.addVertex((Object)this.SUCCESS);
        this.graphUndirectedView = new AsUndirectedGraph(this.graph);
        this.solutionPaths = new HashMap();
        this.sessionStats = new HashMap();
        this.sessionSet = new TreeSet();
        this.sessionList = new ArrayList();
        this.variableNameGenerator = new VariableNameGenerator();
    }

    public SuperModel(SuperModel other) {
        this.id = other.id;
        this.graph = (DefaultDirectedWeightedGraph)other.graph.clone();
        this.graphUndirectedView = new AsUndirectedGraph(this.graph);
        this.solutionPaths = new HashMap<String, SolutionPath>(other.solutionPaths);
        this.variableNameGenerator = new VariableNameGenerator(other.variableNameGenerator);
    }

    public void start(String session, long timestamp, LinkedListModel model) {
        this.frequencyMass += 1.0;
        if (!this.sessionSet.contains(session)) {
            this.sessionSet.add(session);
            this.sessionList.add(session);
        }
        SolutionPath path = this.getCurrentSolutionPath(session);
        if (this.firstState == null) {
            this.firstState = new StateNode(model);
            this.graph.addVertex((Object)this.START);
            this.graph.addVertex((Object)this.firstState);
            this.connect(this.ROOT, this.START, this.firstState);
        } else {
            this.START.increaseFrequency();
            this.firstState.increaseFrequency();
        }
        StateNode lastState = path.getLastState();
        if (lastState != null) {
            lastState.increaseUndoCount();
        }
        path.start(timestamp, this.firstState);
    }

    public void add(String session, long timestamp, ActionNode action, LinkedListModel model) {
        ++this.addCount;
        this.frequencyMass += 1.0;
        StateNode state = new StateNode(model);
        SolutionPath path = this.getCurrentSolutionPath(session);
        SNode lastState = path.getLastState();
        if (lastState == null) {
            lastState = this.ROOT;
        }
        SNode mappedState = null;
        Vector<VariableMapping> mappings = null;
        VariableMapping uniqueMapping = null;
        BreadthFirstIterator graphIterator = new BreadthFirstIterator(this.graphUndirectedView, (Object)lastState);
        while (graphIterator.hasNext()) {
            SNode n = (SNode)graphIterator.next();
            if (!(n instanceof StateNode)) continue;
            ++this.isomorphismCheckCount;
            mappings = state.variableMappings((StateNode)n);
            if (mappings == null) continue;
            ++this.matchedStateNodeCount;
            mappedState = (StateNode)n;
            uniqueMapping = path.disambiguateMapping(mappings);
            break;
        }
        if (mappedState == null) {
            this.getCurrentSessionStats(session).incNotMatchedStates();
            uniqueMapping = VariableMapping.integrateWithNewNames(path.getLastMapping(), state.variableList(), state.notTemporaryVariableList(), this.variableNameGenerator);
            mappedState = new StateNode(state, uniqueMapping);
            model.setFinal(true);
            boolean isCorrectSolution = Evaluator.getInstance().evaluate(model);
            ((StateNode)mappedState).setCorrectSolution(isCorrectSolution);
            this.graph.addVertex((Object)mappedState);
            if (isCorrectSolution) {
                if (!this.graph.containsVertex((Object)this.SUBMIT)) {
                    this.graph.addVertex((Object)this.SUBMIT);
                } else {
                    this.SUBMIT.increaseFrequency();
                }
                this.connect(mappedState, this.SUBMIT, this.SUCCESS);
                this.SUCCESS.increaseFrequency();
            }
        } else {
            this.getCurrentSessionStats(session).incMatchedStates();
            mappedState.increaseFrequency();
        }
        ActionNode mappedAction = new ActionNode(action, uniqueMapping);
        boolean foundMatchingAction = false;
        for (SEdge e : this.graph.incomingEdgesOf((Object)mappedState)) {
            ActionNode a;
            SNode n = (SNode)this.graph.getEdgeSource((Object)e);
            boolean originatesFromLastState = false;
            for (SEdge e1 : this.graph.incomingEdgesOf((Object)n)) {
                if (this.graph.getEdgeSource((Object)e1) != lastState) continue;
                originatesFromLastState = true;
                break;
            }
            if (!originatesFromLastState || !(n instanceof ActionNode) || !(a = (ActionNode)n).isEquivalent(mappedAction)) continue;
            ++this.matchedActionNodeCount;
            mappedAction = a;
            foundMatchingAction = true;
            break;
        }
        if (!foundMatchingAction) {
            this.getCurrentSessionStats(session).incNotMatchedActions();
            this.graph.addVertex((Object)mappedAction);
        } else {
            this.getCurrentSessionStats(session).incMatchedActions();
            mappedAction.increaseFrequency();
        }
        if (lastState != null) {
            this.connect(lastState, mappedAction, mappedState);
        } else {
            this.connect(this.ROOT, mappedAction, mappedState);
        }
        path.add(timestamp, action, state, uniqueMapping, mappedAction, (StateNode)mappedState);
        StateNode s0 = path.getPenultimateState();
        if (s0 != null) {
            s0.addTimeToExit(path.getTimeLag());
        }
        mappedState.addUndoUncertainty(path.getUndoBehavior());
    }

    public void undo(String session, long timestamp) {
        this.frequencyMass += 1.0;
        SolutionPath path = this.getCurrentSolutionPath(session);
        StateNode s0 = path.getLastState();
        path.undo(timestamp);
        StateNode s1 = path.getLastState();
        s1.increaseFrequency();
        s0.addTimeToExit(path.getTimeLag());
        s1.addUndoUncertainty(path.getUndoBehavior());
        s1.increaseUndoCount();
    }

    public void redo(String session, long timestamp) {
        this.frequencyMass += 1.0;
        SolutionPath path = this.getCurrentSolutionPath(session);
        StateNode s0 = path.getLastState();
        path.redo(timestamp);
        path.getLastAction().increaseFrequency();
        StateNode s1 = path.getLastState();
        s1.increaseFrequency();
        s0.addTimeToExit(path.getTimeLag());
        s1.addUndoUncertainty(path.getUndoBehavior());
        s1.increaseUndoCount();
    }

    private void connect(SNode s1, ActionNode a, SNode s2) {
        SEdge e2;
        SEdge e1 = (SEdge)this.graph.getEdge((Object)s1, (Object)a);
        if (e1 == null) {
            e1 = (SEdge)this.graph.addEdge((Object)s1, (Object)a);
        }
        if ((e2 = (SEdge)this.graph.getEdge((Object)a, (Object)s2)) == null) {
            e2 = (SEdge)this.graph.addEdge((Object)a, (Object)s2);
        }
    }

    public SolutionPath getCurrentSolutionPath(String session) {
        SolutionPath path = this.solutionPaths.get(session);
        if (path == null) {
            path = new SolutionPath(session, this.id);
            this.solutionPaths.put(session, path);
        }
        return path;
    }

    public SessionStats getCurrentSessionStats(String session) {
        SessionStats stats = this.sessionStats.get(session);
        if (stats == null) {
            stats = new SessionStats(session);
            this.sessionStats.put(session, stats);
        }
        return stats;
    }

    public void updateProbabilisticValues() {
        this.computeEdgeProbabilities();
        this.computeNodeGoodness();
        this.computeNodeCriticality();
        this.computeBestPathGoodnessDifferential();
        this.resetUndoCounts();
        this.computeFrequencyStats();
    }

    private void computeEdgeProbabilities() {
        for (SNode v : this.graph.vertexSet()) {
            if (v instanceof StateNode) {
                double totalActionFreq = 0.0;
                for (SEdge e : this.graph.outgoingEdgesOf((Object)v)) {
                    totalActionFreq += (double)((SNode)this.graph.getEdgeTarget((Object)e)).getFrequency();
                }
                for (SEdge e : this.graph.outgoingEdgesOf((Object)v)) {
                    double actionFreq = ((SNode)this.graph.getEdgeTarget((Object)e)).getFrequency();
                    double w = -Math.log(actionFreq / totalActionFreq);
                    this.graph.setEdgeWeight((Object)e, w);
                }
                continue;
            }
            for (SEdge e : this.graph.outgoingEdgesOf((Object)v)) {
                this.graph.setEdgeWeight((Object)e, 0.0);
            }
        }
    }

    private void computeNodeGoodness() {
        for (SNode v : this.graph.vertexSet()) {
            if (v instanceof StateNode) {
                StateNode s = (StateNode)v;
                KShortestPaths pathFinder = new KShortestPaths(this.graph, (Object)s, 10);
                List paths = pathFinder.getPaths((Object)this.SUCCESS);
                double nodeGoodness = 0.0;
                if (paths != null) {
                    for (GraphPath p : paths) {
                        double d = Math.exp(-p.getWeight());
                        nodeGoodness += d;
                    }
                }
                s.setGoodness(nodeGoodness);
                this.goodnessMass += s.getGoodnessMass();
                continue;
            }
            if (!(v instanceof SpecialNode)) continue;
            v.setGoodness(1.0);
        }
        for (SNode v : this.graph.vertexSet()) {
            if (!(v instanceof ActionNode)) continue;
            for (SEdge e : this.graph.outgoingEdgesOf((Object)v)) {
                double g = ((SNode)this.graph.getEdgeTarget((Object)e)).getGoodness();
                v.setGoodness(g);
            }
        }
    }

    private void computeNodeCriticality() {
        for (SNode v : this.graph.vertexSet()) {
            if (!(v instanceof StateNode)) continue;
            StateNode currentState = (StateNode)v;
            double criticality = 0.0;
            for (SEdge e1 : this.graph.outgoingEdgesOf((Object)currentState)) {
                SNode n1 = (SNode)this.graph.getEdgeTarget((Object)e1);
                if (!(n1 instanceof ActionNode)) continue;
                ActionNode action = (ActionNode)n1;
                for (SEdge e2 : this.graph.outgoingEdgesOf((Object)action)) {
                    StateNode nextState;
                    double goodness;
                    SNode n2 = (SNode)this.graph.getEdgeTarget((Object)e2);
                    if (!(n2 instanceof StateNode) || (goodness = (nextState = (StateNode)n2).getGoodness()) != 0.0) continue;
                    double probability = Math.exp(-this.graph.getEdgeWeight((Object)e1));
                    criticality += probability;
                }
            }
            currentState.setCriticality(criticality);
        }
    }

    private void computeBestPathGoodnessDifferential() {
        KShortestPaths pathFinder = new KShortestPaths(this.graph, (Object)this.ROOT, 1);
        List paths = pathFinder.getPaths((Object)this.SUCCESS);
        if (paths == null) {
            return;
        }
        GraphPath path = (GraphPath)paths.get(0);
        List vPath = Graphs.getPathVertexList((GraphPath)path);
        ArrayList<StateNode> statePath = new ArrayList<StateNode>();
        for (SNode v : vPath) {
            if (!(v instanceof StateNode)) continue;
            statePath.add((StateNode)v);
            v.setOnBestPath(true);
        }
        int i = 1;
        while (i < statePath.size()) {
            StateNode s0 = (StateNode)statePath.get(i - 1);
            StateNode s1 = (StateNode)statePath.get(i);
            double gs0 = s0.getGoodness();
            double gs1 = s1.getGoodness();
            double d = gs1 - gs0;
            this.bestPathGoodnessDifferential.addSample(d);
            ++i;
        }
    }

    private void resetUndoCounts() {
        for (SNode s : this.graph.vertexSet()) {
            s.resetUndoCount();
        }
    }

    private void computeFrequencyStats() {
        this.frequencyStats.clear();
        for (SNode s : this.graph.vertexSet()) {
            if (!(s instanceof StateNode)) continue;
            this.frequencyStats.addSample(s.getFrequency());
        }
    }

    public String toString() {
        HashMap<SNode, Integer> nodeIDs = new HashMap<SNode, Integer>();
        StringBuilder sb = new StringBuilder();
        sb.append("digraph supermodel" + this.id + " {\n");
        DepthFirstIterator graphIterator = new DepthFirstIterator(this.graph, (Object)this.ROOT);
        int nodeNumber = 0;
        while (graphIterator.hasNext()) {
            SNode v = (SNode)graphIterator.next();
            nodeIDs.put(v, ++nodeNumber);
            sb.append("  " + v.dotNodeDefinition(nodeNumber) + "\n");
        }
        sb.append("\n");
        for (SEdge e : this.graph.edgeSet()) {
            SNode source = (SNode)this.graph.getEdgeSource((Object)e);
            SNode target = (SNode)this.graph.getEdgeTarget((Object)e);
            double weight = this.graph.getEdgeWeight((Object)e);
            weight = Math.exp(-weight);
            if (source instanceof ActionNode) {
                sb.append(String.format(" %s -> %s [penwidth=3,arrowsize=2,weight=100];\n", source.dotNodeID((Integer)nodeIDs.get(source)), target.dotNodeID((Integer)nodeIDs.get(target))));
                continue;
            }
            sb.append(String.format(" %s -> %s [penwidth=3,arrowsize=2,fontsize=40,label=\"%.2f\",weight=%.2f];\n", source.dotNodeID((Integer)nodeIDs.get(source)), target.dotNodeID((Integer)nodeIDs.get(target)), weight, 10.0 * weight + 1.0));
        }
        sb.append("}\n");
        for (SNode v : this.graph.vertexSet()) {
            if (!(v instanceof StateNode)) continue;
            StateNode n = (StateNode)v;
            double nodeStrength = 1.0;
            sb.append("\n" + n.toDOT((Integer)nodeIDs.get(v), nodeStrength));
        }
        return sb.toString();
    }

    public void printStatistics() {
        System.out.println("----- SuperModel statistics -----");
        System.out.println("ID:                   " + this.id);
        System.out.println("add count:            " + this.addCount);
        System.out.println("isomorphism checks:   " + this.isomorphismCheckCount);
        System.out.println("avg isoCheck / add:   " + (double)this.isomorphismCheckCount / (double)this.addCount);
        System.out.println("matched state count:  " + this.matchedStateNodeCount);
        System.out.println("matched state ratio:  " + (double)this.matchedStateNodeCount / (double)this.addCount);
        System.out.println("matched action count: " + this.matchedActionNodeCount);
        System.out.println("matched action ratio: " + (double)this.matchedActionNodeCount / (double)this.addCount);
        int nStates = 0;
        int nActions = 0;
        for (SNode v : this.graph.vertexSet()) {
            if (v instanceof StateNode) {
                ++nStates;
                continue;
            }
            if (!(v instanceof ActionNode)) continue;
            ++nActions;
        }
        System.out.println("# states:  " + nStates);
        System.out.println("# actions: " + nActions);
        System.out.println("# START:   " + this.START.getFrequency());
        System.out.println("# SUCCESS: " + this.SUCCESS.getFrequency());
        System.out.println("Frequency mass:    " + this.frequencyMass);
        System.out.println("Goodness mass:     " + this.goodnessMass);
        System.out.println("Rel goodness mass: " + this.goodnessMass / this.frequencyMass);
        System.out.println("----- End statistics ------------");
    }

    public void printStates() {
        System.out.println("model,state,frequency,goodness,criticality,bestpath,correctsolution,meantime,sdtime,meanundo,sdundo");
        DepthFirstIterator graphIterator = new DepthFirstIterator(this.graph, (Object)this.ROOT);
        int nodeNumber = 0;
        while (graphIterator.hasNext()) {
            ++nodeNumber;
            SNode v = (SNode)graphIterator.next();
            if (!(v instanceof StateNode)) continue;
            StateNode s = (StateNode)v;
            System.out.println("M" + this.id + ",S" + nodeNumber + "," + s.getFrequency() + "," + s.getGoodness() + "," + s.getCriticality() + "," + s.isOnBestPath() + "," + s.isCorrectSolution() + "," + s.meanTimeToExit() + "," + s.stdevTimeToExit() + "," + s.meanUndoUncertainty() + "," + s.stdevUndoUncertainty());
        }
    }

    public String getId() {
        return this.id;
    }

    public Vector<SolutionPath> getSolutionPaths() {
        Vector<SolutionPath> v = new Vector<SolutionPath>();
        TreeSet<String> sessions = new TreeSet<String>(this.solutionPaths.keySet());
        for (String s : sessions) {
            v.add(this.solutionPaths.get(s));
        }
        return v;
    }

    public void forgetSolutionPaths() {
        this.solutionPaths.clear();
        this.sessionStats.clear();
    }

    public double getBestPathGoodnessDifferentialMean() {
        return this.bestPathGoodnessDifferential.mean();
    }

    public double getBestPathGoodnessDifferentialStdev() {
        return this.bestPathGoodnessDifferential.stdev();
    }

    public ArrayList<String> getSessionList() {
        return this.sessionList;
    }

    public ArrayList<ActionRecord> futureActions(String session) {
        SolutionPath path = this.getCurrentSolutionPath(session);
        StateNode currentState = path.getLastState();
        StateSpace currentStudentState = path.getLastRawState().getStateSpace();
        VariableMapping currentMapping = path.getLastMapping().inverseMapping();
        ArrayList<ActionRecord> actions = new ArrayList<ActionRecord>();
        for (SEdge e1 : this.graph.outgoingEdgesOf((Object)currentState)) {
            SNode n1 = (SNode)this.graph.getEdgeTarget((Object)e1);
            if (!(n1 instanceof ActionNode)) continue;
            ActionNode action = (ActionNode)n1;
            for (SEdge e2 : this.graph.outgoingEdgesOf((Object)action)) {
                SNode n2 = (SNode)this.graph.getEdgeTarget((Object)e2);
                if (!(n2 instanceof StateNode)) continue;
                StateNode futureState = (StateNode)n2;
                ActionRecord actRec = new ActionRecord();
                actRec.modelState1 = currentState;
                actRec.studentState1 = currentStudentState;
                actRec.action = action;
                actRec.probability = Math.exp(-this.graph.getEdgeWeight((Object)e1));
                actRec.mapping = VariableMapping.integrateWithIdentity(currentMapping, futureState.variableList());
                actRec.mapping.changeUnfriendlyValues();
                actRec.modelState2 = futureState;
                actRec.studentState2 = new StateSpace(futureState.getStateSpace(), actRec.mapping);
                double goodness = futureState.getGoodness();
                actRec.fgoodness = 2.0 * actRec.probability * goodness / (actRec.probability + goodness);
                actions.add(actRec);
            }
        }
        return actions;
    }

    public double getFrequencyMass() {
        return this.frequencyMass;
    }

    public double getGoodnessMass() {
        return this.goodnessMass;
    }
}

