/*
 * Decompiled with CFR 0.152.
 */
package ilist.supermodel;

import ilist.misc.Util;
import ilist.model.MultiModel;
import ilist.problem.Problem;
import ilist.problem.ProblemSet;
import ilist.statement.SimpleParser07;
import ilist.statement.Statement;
import ilist.supermodel.ActionNode;
import ilist.supermodel.SuperModel;
import ilist.supermodel.SuperModelSet;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;

public class SuperModelFactory {
    static Pattern pTrial = Pattern.compile("(?s)<trial session=\"(.*?)\" problem=\"(.*?)\">(.*?)</trial>");
    private static Pattern pStart = Pattern.compile("<start time=\"(.*?)\"/>");
    private static Pattern pCommand = Pattern.compile("<command time=\"(.*?)\">(.*?)</command>");
    private static Pattern pUndo = Pattern.compile("<undo time=\"(.*?)\"/>");
    private static Pattern pRedo = Pattern.compile("<redo time=\"(.*?)\"/>");
    private static Pattern pDone = Pattern.compile("<done time=\"(.*?)\"/>");
    private static Pattern pSuccess = Pattern.compile("<success time=\"(.*?)\"/>");

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String logFileName = stringArray[n2];
            String xmlLog = Util.slurpFile(logFileName);
            SuperModelSet superModels = SuperModelFactory.createSuperModelSet(xmlLog);
            superModels.saveDotModels(String.valueOf(logFileName) + ".");
            superModels.saveCompressedSet(String.valueOf(logFileName) + ".supermodels-paths.obj.gz");
            superModels.forgetSolutionPaths();
            superModels.saveCompressedSet(String.valueOf(logFileName) + ".supermodels.obj.gz");
            ++n2;
        }
    }

    public static SuperModelSet loadSuperModelSet(InputStream supermodels) {
        SuperModelSet sm = null;
        try {
            GZIPInputStream gz = new GZIPInputStream(supermodels);
            ObjectInputStream ois = new ObjectInputStream(gz);
            sm = (SuperModelSet)ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sm;
    }

    public static SuperModelSet createSuperModelSet(String xmlLog) {
        SuperModelSet superModels = new SuperModelSet();
        SimpleParser07 simpleParser = new SimpleParser07();
        Matcher mTrial = pTrial.matcher(xmlLog);
        block2: while (mTrial.find()) {
            String session = mTrial.group(1);
            String problemId = mTrial.group(2);
            if (problemId.equals("6") || problemId.equals("7")) continue;
            String xmlTrial = mTrial.group(3);
            MultiModel multiModel = new MultiModel();
            Scanner s = new Scanner(xmlTrial);
            while (s.hasNextLine()) {
                String line = s.nextLine();
                try {
                    Problem p;
                    long time;
                    Matcher m = pStart.matcher(line);
                    if (m.matches()) {
                        time = Long.parseLong(m.group(1));
                        p = ProblemSet.getInstance().get(problemId);
                        multiModel.setProblem(p);
                        superModels.getSuperModel(p).start(session, time, multiModel.getCurrentModel());
                        continue;
                    }
                    m = pCommand.matcher(line);
                    if (m.matches()) {
                        time = Long.parseLong(m.group(1));
                        String command = m.group(2);
                        Problem problem = multiModel.getProblem();
                        Statement st = simpleParser.parse(command);
                        if (st == null) {
                            System.err.println("--- parse error: session " + session + " time " + time + " problem " + problem.getId() + " ---\n" + command + "\n--- end error ---");
                            continue;
                        }
                        String error = multiModel.execute(st, true);
                        if (error != null) {
                            System.err.println("--- execution error: session " + session + " time " + time + " problem " + problem.getId() + " ---\n" + error + "\n--- end error ---");
                            continue;
                        }
                        superModels.getSuperModel(problem).add(session, time, new ActionNode(st), multiModel.getCurrentModel());
                        continue;
                    }
                    m = pUndo.matcher(line);
                    if (m.matches()) {
                        time = Long.parseLong(m.group(1));
                        multiModel.undo();
                        p = multiModel.getProblem();
                        superModels.getSuperModel(p).undo(session, time);
                        continue;
                    }
                    m = pRedo.matcher(line);
                    if (m.matches()) {
                        time = Long.parseLong(m.group(1));
                        multiModel.redo();
                        p = multiModel.getProblem();
                        superModels.getSuperModel(p).redo(session, time);
                        continue;
                    }
                    m = pDone.matcher(line);
                    if (m.matches()) continue;
                    m = pSuccess.matcher(line);
                    m.matches();
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                    System.err.println("--------------------");
                    System.err.println(xmlTrial);
                    System.err.println("--- " + line);
                    System.err.println("--------------------");
                    continue block2;
                }
            }
        }
        for (SuperModel sm : superModels) {
            sm.updateProbabilisticValues();
        }
        return superModels;
    }
}

