/*
 * Decompiled with CFR 0.152.
 */
package ilist.supermodel;

import ilist.supermodel.SolutionPath;
import ilist.supermodel.SuperModel;
import ilist.supermodel.SuperModelFactory;
import ilist.supermodel.SuperModelSet;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class SuperModelInspector {
    public static void main(String[] args) {
        String smFileName = args[0];
        try {
            SuperModelSet sms = SuperModelFactory.loadSuperModelSet(new FileInputStream(smFileName));
            sms.printStatistics();
            System.out.println("--- BEGIN states ---");
            for (SuperModel sm : sms) {
                sm.printStates();
            }
            System.out.println("--- END states ---");
            System.out.println("--- BEGIN path statistics ---");
            System.out.println(SolutionPath.statisticsHeader());
            for (SuperModel sm : sms) {
                for (SolutionPath p : sm.getSolutionPaths()) {
                    System.out.println(p.statistics());
                }
            }
            System.out.println("--- END path statistics ---");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }
}

