/*
 * Decompiled with CFR 0.152.
 */
package ilist.supermodel;

import ilist.misc.Util;
import ilist.problem.Problem;
import ilist.supermodel.SessionStats;
import ilist.supermodel.SuperModel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.zip.GZIPOutputStream;

public class SuperModelSet
implements Iterable<SuperModel>,
Serializable {
    private static final long serialVersionUID = 1L;
    private HashMap<Problem, SuperModel> problemSuperModels = new HashMap();

    @Override
    public Iterator<SuperModel> iterator() {
        return this.problemSuperModels.values().iterator();
    }

    public SuperModel getSuperModel(Problem problem) {
        SuperModel sm = this.problemSuperModels.get(problem);
        if (sm == null) {
            sm = new SuperModel(problem.getId());
            this.problemSuperModels.put(problem, sm);
        }
        return sm;
    }

    public void printStatistics() {
        TreeMap<String, Problem> pidMap = new TreeMap<String, Problem>();
        for (Problem p : this.problemSuperModels.keySet()) {
            pidMap.put(p.getId(), p);
        }
        for (Problem p : pidMap.values()) {
            this.problemSuperModels.get(p).printStatistics();
        }
    }

    public void printSessionStats(String prefix) {
        TreeMap<String, Problem> pidMap = new TreeMap<String, Problem>();
        for (Problem p : this.problemSuperModels.keySet()) {
            pidMap.put(p.getId(), p);
        }
        for (Problem p : pidMap.values()) {
            SuperModel sm = this.problemSuperModels.get(p);
            ArrayList<String> sessionList = sm.getSessionList();
            int i = 0;
            while (i < sessionList.size()) {
                String session = sessionList.get(i);
                SessionStats stats = sm.getCurrentSessionStats(session);
                String line = String.valueOf(prefix) + p.getId() + "," + (i + 1) + "," + stats.toString();
                System.out.println(line);
                ++i;
            }
        }
    }

    public void saveDotModels(String prefix) {
        for (Problem p : this.problemSuperModels.keySet()) {
            SuperModel sm = this.problemSuperModels.get(p);
            Util.saveString(sm.toString(), String.valueOf(prefix) + "supermodel-" + sm.getId() + ".dot");
        }
    }

    public void forgetSolutionPaths() {
        for (SuperModel s : this.problemSuperModels.values()) {
            s.forgetSolutionPaths();
        }
    }

    public void saveCompressedSet(String filename) {
        try {
            FileOutputStream fos = new FileOutputStream(filename);
            GZIPOutputStream gz = new GZIPOutputStream(fos);
            ObjectOutputStream oos = new ObjectOutputStream(gz);
            oos.writeObject(this);
            oos.flush();
            oos.close();
            fos.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

