/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import simplenlg.features.AdjectivePosition;
import simplenlg.features.AdjectiveType;
import simplenlg.features.Category;
import simplenlg.features.InflectionType;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.morph.AdjectiveInflection;

public class Adjective
extends ContentWord {
    private String comparativeForm;
    private String superlativeForm;
    Set<AdjectivePosition> positions;
    AdjectiveType type;

    public Adjective(String baseform) {
        super(baseform);
        this.category = Category.ADJECTIVE;
        this.positions = new HashSet<AdjectivePosition>();
        this.type = AdjectiveType.NON_STATIVE;
    }

    public Adjective(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Adjective(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public String getComparative() {
        if (this.comparativeForm == null && this.inflectionType != InflectionType.PERIPHRASTIC) {
            this.comparativeForm = AdjectiveInflection.COMPARATIVE.apply(this.baseForm);
        }
        return this.comparativeForm;
    }

    public void setComparative(String comp) {
        this.comparativeForm = comp;
    }

    public String getSuperlative() {
        if (this.superlativeForm == null) {
            this.superlativeForm = AdjectiveInflection.SUPERLATIVE.apply(this.baseForm);
        }
        return this.superlativeForm;
    }

    public void setSuperlative(String sup) {
        this.superlativeForm = sup;
    }

    public Collection<AdjectivePosition> getPositions() {
        return this.positions;
    }

    public void addPosition(AdjectivePosition position) {
        this.positions.add(position);
    }

    public void setPositions(Collection<AdjectivePosition> pos) {
        this.positions.clear();
        this.positions.addAll(pos);
    }

    public boolean hasPosition(AdjectivePosition position) {
        return this.positions.contains(position);
    }

    public AdjectiveType getType() {
        return this.type;
    }

    public void setType(AdjectiveType type) {
        this.type = type;
    }

    public boolean isStative() {
        return this.type == AdjectiveType.STATIVE;
    }
}

