/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import simplenlg.features.ComplementFrame;
import simplenlg.features.ComplementSlot;
import simplenlg.features.ComplementType;
import simplenlg.lexicon.lexicalitems.Word;

public abstract class ContentWord
extends Word {
    List<ComplementFrame> complementationFrames;
    boolean whfin;
    boolean whinf;
    boolean inf;
    boolean binf;
    boolean fin;
    boolean as;
    boolean ed;
    boolean ing;
    boolean np;
    boolean adj;
    boolean adv;
    boolean pp;

    ContentWord() {
        this.inflectionType = null;
        this.complementationFrames = new ArrayList<ComplementFrame>();
    }

    public ContentWord(String baseform) {
        this();
        this.baseForm = baseform;
    }

    public ContentWord(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public ContentWord(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public Collection<ComplementFrame> getComplementationFrames() {
        return this.complementationFrames;
    }

    public void setComplementationFrames(Collection<ComplementFrame> compFrames) {
        this.complementationFrames.clear();
        for (ComplementFrame frame : compFrames) {
            this.addComplementFrame(frame);
        }
    }

    public boolean hasComplementationFrame() {
        return !this.complementationFrames.isEmpty();
    }

    public void addComplementFrame(ComplementFrame complementFrame) {
        this.complementationFrames.add(complementFrame);
        for (ComplementSlot slot : complementFrame.getComplementSlots()) {
            this.updateFeatures(slot.getType());
        }
    }

    public boolean allowsClauseComp() {
        return this.whfin || this.whinf || this.inf || this.binf || this.fin;
    }

    public boolean allowsWhComp() {
        return this.whfin || this.whinf;
    }

    public boolean allowsFinComp() {
        return this.fin || this.whfin;
    }

    public boolean allowsInfComp() {
        return this.inf || this.binf || this.whinf;
    }

    public boolean allowsBareInfComp() {
        return this.binf;
    }

    public boolean allowsAsComp() {
        return this.as;
    }

    public boolean allowsNPComp() {
        return this.np;
    }

    public boolean allowsAdvComp() {
        return this.adv;
    }

    public boolean allowsAdjComp() {
        return this.adj;
    }

    public boolean allowsPPComp() {
        return this.pp;
    }

    public boolean allowsEdComp() {
        return this.ed;
    }

    public boolean allowsIngComp() {
        return this.ing;
    }

    private void updateFeatures(ComplementType type) {
        switch (type) {
            case INF: {
                this.inf = true;
                break;
            }
            case BARE_INF: {
                this.binf = true;
                break;
            }
            case ED: {
                this.ed = true;
                break;
            }
            case ING: {
                this.ing = true;
                break;
            }
            case FINCOMP: {
                this.fin = true;
                break;
            }
            case WHFINCOMP: {
                this.whfin = true;
                break;
            }
            case WHINFCOMP: {
                this.whinf = true;
                break;
            }
            case AS_COMP: {
                this.as = true;
                break;
            }
            case PP: {
                this.pp = true;
                break;
            }
            case NP: {
                this.np = true;
                break;
            }
            case ADJP: {
                this.adj = true;
                break;
            }
            case ADVP: {
                this.adv = true;
            }
        }
    }
}

